/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.core.contourdetector.ContourDetector;
import io.scanbot.sdk.docprocessing.legacy.DraftPageProcessor;
import io.scanbot.sdk.persistence.cleanup.Cleaner;
import io.scanbot.sdk.persistence.page.legacy.draft.DraftPageFileStorage;
import io.scanbot.sdk.persistence.page.legacy.draft.DraftPageStorageProcessor;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.ui.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui.di.components.DocumentScannerComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.DispatchersModule;
import io.scanbot.sdk.ui.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.DocumentScannerModule;
import io.scanbot.sdk.ui.di.modules.DocumentScannerModule_ProvideDocumentScannerCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.PermissionsModule;
import io.scanbot.sdk.ui.di.modules.PermissionsModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui.view.base.NFBaseActivity;
import io.scanbot.sdk.ui.view.base.NFBaseActivity_MembersInjector;
import io.scanbot.sdk.ui.view.base.PermissionViewModel;
import io.scanbot.sdk.ui.view.camera.BaseDocumentScannerActivity;
import io.scanbot.sdk.ui.view.camera.BaseDocumentScannerActivity_MembersInjector;
import io.scanbot.sdk.ui.view.camera.DocumentScannerActivity;
import io.scanbot.sdk.ui.view.camera.DocumentScannerCameraViewModel;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase_Factory;
import io.scanbot.sdk.ui.view.interactor.FilterDraftDocumentPageUseCase;
import io.scanbot.sdk.ui.view.interactor.FilterDraftDocumentPageUseCase_Factory;
import io.scanbot.sdk.ui.view.interactor.FinalizePagesUseCase;
import io.scanbot.sdk.ui.view.interactor.FinalizePagesUseCase_Factory;
import io.scanbot.sdk.ui.view.interactor.RemoveDraftPageUseCase;
import io.scanbot.sdk.ui.view.interactor.RemoveDraftPageUseCase_Factory;
import io.scanbot.sdk.ui.view.interactor.SaveTakenPictureUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveTakenPictureUseCase_Factory;
import java.util.Map;

@DaggerGenerated
public final class DaggerDocumentScannerComponent {
    private DaggerDocumentScannerComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DocumentScannerModule documentScannerModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private PermissionsModule permissionsModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder documentScannerModule(DocumentScannerModule documentScannerModule) {
            this.documentScannerModule = (DocumentScannerModule)Preconditions.checkNotNull((Object)documentScannerModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder permissionsModule(PermissionsModule permissionsModule) {
            this.permissionsModule = (PermissionsModule)Preconditions.checkNotNull((Object)permissionsModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public DocumentScannerComponent build() {
            if (this.documentScannerModule == null) {
                this.documentScannerModule = new DocumentScannerModule();
            }
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.permissionsModule == null) {
                this.permissionsModule = new PermissionsModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new DocumentScannerComponentImpl(this.documentScannerModule, this.viewModelFactoryModule, this.permissionsModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class DocumentScannerComponentImpl
    implements DocumentScannerComponent {
        private final SDKUIComponent sDKUIComponent;
        private final DocumentScannerComponentImpl documentScannerComponentImpl = this;
        private Provider<ContourDetector> contourDetectorProvider;
        private Provider<DraftPageFileStorage> draftPageFileStorageProvider;
        private Provider<SaveTakenPictureUseCase> saveTakenPictureUseCaseProvider;
        private Provider<DraftPageProcessor> draftPageProcessorProvider;
        private Provider<FilterDraftDocumentPageUseCase> filterDraftDocumentPageUseCaseProvider;
        private Provider<Cleaner> provideCleanerProvider;
        private Provider<RemoveDraftPageUseCase> removeDraftPageUseCaseProvider;
        private Provider<DraftPageStorageProcessor> draftPageStorageProcessorProvider;
        private Provider<FinalizePagesUseCase> finalizePagesUseCaseProvider;
        private Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        private Provider<ViewModel> provideDocumentScannerCameraViewModelProvider;
        private Provider<Context> provideContextProvider;
        private Provider<CheckCameraPermissionUseCase> checkCameraPermissionUseCaseProvider;
        private Provider<ViewModel> provideBarcodeCameraViewModelProvider2;
        private Provider mapOfClassOfAndProviderOfViewModelProvider;
        private Provider<ViewModelProvider.Factory> bindViewModelFactoryProvider;

        private DocumentScannerComponentImpl(DocumentScannerModule documentScannerModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.sDKUIComponent = sDKUIComponentParam;
            this.initialize(documentScannerModuleParam, viewModelFactoryModuleParam, permissionsModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        private void initialize(DocumentScannerModule documentScannerModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.contourDetectorProvider = new ContourDetectorProvider(sDKUIComponentParam);
            this.draftPageFileStorageProvider = new DraftPageFileStorageProvider(sDKUIComponentParam);
            this.saveTakenPictureUseCaseProvider = SaveTakenPictureUseCase_Factory.create(this.draftPageFileStorageProvider);
            this.draftPageProcessorProvider = new DraftPageProcessorProvider(sDKUIComponentParam);
            this.filterDraftDocumentPageUseCaseProvider = FilterDraftDocumentPageUseCase_Factory.create(this.draftPageProcessorProvider);
            this.provideCleanerProvider = new ProvideCleanerProvider(sDKUIComponentParam);
            this.removeDraftPageUseCaseProvider = RemoveDraftPageUseCase_Factory.create(this.provideCleanerProvider);
            this.draftPageStorageProcessorProvider = new DraftPageStorageProcessorProvider(sDKUIComponentParam);
            this.finalizePagesUseCaseProvider = FinalizePagesUseCase_Factory.create(this.draftPageStorageProcessorProvider);
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.provideDocumentScannerCameraViewModelProvider = DoubleCheck.provider((Provider)DocumentScannerModule_ProvideDocumentScannerCameraViewModelFactory.create(documentScannerModuleParam, this.contourDetectorProvider, this.saveTakenPictureUseCaseProvider, this.filterDraftDocumentPageUseCaseProvider, this.removeDraftPageUseCaseProvider, this.finalizePagesUseCaseProvider, this.provideBarcodeCameraViewModelProvider));
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.checkCameraPermissionUseCaseProvider = CheckCameraPermissionUseCase_Factory.create(this.provideContextProvider);
            this.provideBarcodeCameraViewModelProvider2 = DoubleCheck.provider((Provider)PermissionsModule_ProvideBarcodeCameraViewModelFactory.create(permissionsModuleParam, this.checkCameraPermissionUseCaseProvider));
            this.mapOfClassOfAndProviderOfViewModelProvider = MapProviderFactory.builder((int)2).put(DocumentScannerCameraViewModel.class, this.provideDocumentScannerCameraViewModelProvider).put(PermissionViewModel.class, this.provideBarcodeCameraViewModelProvider2).build();
            this.bindViewModelFactoryProvider = DoubleCheck.provider((Provider)ViewModelFactoryModule_BindViewModelFactoryFactory.create(viewModelFactoryModuleParam, (javax.inject.Provider<Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>>>)this.mapOfClassOfAndProviderOfViewModelProvider));
        }

        @Override
        public void inject(DocumentScannerActivity documentScannerActivity) {
            this.injectDocumentScannerActivity(documentScannerActivity);
        }

        private DocumentScannerActivity injectDocumentScannerActivity(DocumentScannerActivity instance) {
            NFBaseActivity_MembersInjector.injectCameraUiSettings((NFBaseActivity)instance, (CameraUiSettings)((CameraUiSettings)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.cameraUiSettings())));
            BaseDocumentScannerActivity_MembersInjector.injectFactory((BaseDocumentScannerActivity)instance, (ViewModelProvider.Factory)((ViewModelProvider.Factory)this.bindViewModelFactoryProvider.get()));
            return instance;
        }

        private static final class ContourDetectorProvider
        implements Provider<ContourDetector> {
            private final SDKUIComponent sDKUIComponent;

            ContourDetectorProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public ContourDetector get() {
                return (ContourDetector)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.contourDetector());
            }
        }

        private static final class DraftPageFileStorageProvider
        implements Provider<DraftPageFileStorage> {
            private final SDKUIComponent sDKUIComponent;

            DraftPageFileStorageProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public DraftPageFileStorage get() {
                return (DraftPageFileStorage)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.draftPageFileStorage());
            }
        }

        private static final class DraftPageProcessorProvider
        implements Provider<DraftPageProcessor> {
            private final SDKUIComponent sDKUIComponent;

            DraftPageProcessorProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public DraftPageProcessor get() {
                return (DraftPageProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.draftPageProcessor());
            }
        }

        private static final class ProvideCleanerProvider
        implements Provider<Cleaner> {
            private final SDKUIComponent sDKUIComponent;

            ProvideCleanerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Cleaner get() {
                return (Cleaner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideCleaner());
            }
        }

        private static final class DraftPageStorageProcessorProvider
        implements Provider<DraftPageStorageProcessor> {
            private final SDKUIComponent sDKUIComponent;

            DraftPageStorageProcessorProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public DraftPageStorageProcessor get() {
                return (DraftPageStorageProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.draftPageStorageProcessor());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }
    }
}

