/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.documentdata.DocumentDataExtractor;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.ui.di.components.DocumentDataComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.DocumentDataModule;
import io.scanbot.sdk.ui.di.modules.DocumentDataModule_ProvideDocumentDataCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.DocumentDataModule_ProvideDocumentDataExtractor$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.di.modules.DocumentDataModule_ProvideDocumentDataFieldListViewModelFactory;
import io.scanbot.sdk.ui.di.modules.DocumentDataModule_ProvideDocumentDataSession$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.di.modules.PermissionsModule;
import io.scanbot.sdk.ui.di.modules.PermissionsModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui.view.base.NFBaseActivity;
import io.scanbot.sdk.ui.view.base.NFBaseActivity_MembersInjector;
import io.scanbot.sdk.ui.view.base.PermissionViewModel;
import io.scanbot.sdk.ui.view.documentdata.BaseDocumentDataExtractorActivity;
import io.scanbot.sdk.ui.view.documentdata.BaseDocumentDataExtractorActivity_MembersInjector;
import io.scanbot.sdk.ui.view.documentdata.DocumentDataCameraViewModel;
import io.scanbot.sdk.ui.view.documentdata.DocumentDataExtractionSession;
import io.scanbot.sdk.ui.view.documentdata.DocumentDataExtractorActivity;
import io.scanbot.sdk.ui.view.documentdata.list.DocumentDataFieldListViewModel;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase_Factory;
import java.util.Map;

@DaggerGenerated
public final class DaggerDocumentDataComponent {
    private DaggerDocumentDataComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DocumentDataModule documentDataModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private PermissionsModule permissionsModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder documentDataModule(DocumentDataModule documentDataModule) {
            this.documentDataModule = (DocumentDataModule)Preconditions.checkNotNull((Object)documentDataModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder permissionsModule(PermissionsModule permissionsModule) {
            this.permissionsModule = (PermissionsModule)Preconditions.checkNotNull((Object)permissionsModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public DocumentDataComponent build() {
            if (this.documentDataModule == null) {
                this.documentDataModule = new DocumentDataModule();
            }
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.permissionsModule == null) {
                this.permissionsModule = new PermissionsModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new DocumentDataComponentImpl(this.documentDataModule, this.viewModelFactoryModule, this.permissionsModule, this.sDKUIComponent);
        }
    }

    private static final class DocumentDataComponentImpl
    implements DocumentDataComponent {
        private final SDKUIComponent sDKUIComponent;
        private final DocumentDataComponentImpl documentDataComponentImpl = this;
        Provider<DocumentDataExtractor> documentDataExtractorProvider;
        Provider<DocumentDataExtractor> provideDocumentDataExtractor$rtu_ui_bundle_releaseProvider;
        Provider<DocumentDataExtractionSession> provideDocumentDataSession$rtu_ui_bundle_releaseProvider;
        Provider<ViewModel> provideDocumentDataCameraViewModelProvider;
        Provider<ViewModel> provideDocumentDataFieldListViewModelProvider;
        Provider<Context> provideContextProvider;
        Provider<CheckCameraPermissionUseCase> checkCameraPermissionUseCaseProvider;
        Provider<ViewModel> provideBarcodeCameraViewModelProvider;
        Provider mapOfClassOfAndProviderOfViewModelProvider;
        Provider<ViewModelProvider.Factory> bindViewModelFactoryProvider;

        DocumentDataComponentImpl(DocumentDataModule documentDataModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.sDKUIComponent = sDKUIComponentParam;
            this.initialize(documentDataModuleParam, viewModelFactoryModuleParam, permissionsModuleParam, sDKUIComponentParam);
        }

        private void initialize(DocumentDataModule documentDataModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.documentDataExtractorProvider = new DocumentDataExtractorProvider(sDKUIComponentParam);
            this.provideDocumentDataExtractor$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)DocumentDataModule_ProvideDocumentDataExtractor$rtu_ui_bundle_releaseFactory.create(documentDataModuleParam, this.documentDataExtractorProvider));
            this.provideDocumentDataSession$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)DocumentDataModule_ProvideDocumentDataSession$rtu_ui_bundle_releaseFactory.create(documentDataModuleParam, this.provideDocumentDataExtractor$rtu_ui_bundle_releaseProvider));
            this.provideDocumentDataCameraViewModelProvider = DoubleCheck.provider((Provider)DocumentDataModule_ProvideDocumentDataCameraViewModelFactory.create(documentDataModuleParam, this.provideDocumentDataSession$rtu_ui_bundle_releaseProvider, this.provideDocumentDataExtractor$rtu_ui_bundle_releaseProvider));
            this.provideDocumentDataFieldListViewModelProvider = DoubleCheck.provider((Provider)DocumentDataModule_ProvideDocumentDataFieldListViewModelFactory.create(documentDataModuleParam, this.provideDocumentDataSession$rtu_ui_bundle_releaseProvider));
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.checkCameraPermissionUseCaseProvider = CheckCameraPermissionUseCase_Factory.create(this.provideContextProvider);
            this.provideBarcodeCameraViewModelProvider = DoubleCheck.provider((Provider)PermissionsModule_ProvideBarcodeCameraViewModelFactory.create(permissionsModuleParam, this.checkCameraPermissionUseCaseProvider));
            this.mapOfClassOfAndProviderOfViewModelProvider = MapProviderFactory.builder((int)3).put(DocumentDataCameraViewModel.class, this.provideDocumentDataCameraViewModelProvider).put(DocumentDataFieldListViewModel.class, this.provideDocumentDataFieldListViewModelProvider).put(PermissionViewModel.class, this.provideBarcodeCameraViewModelProvider).build();
            this.bindViewModelFactoryProvider = DoubleCheck.provider((Provider)ViewModelFactoryModule_BindViewModelFactoryFactory.create(viewModelFactoryModuleParam, (Provider<Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>>>)this.mapOfClassOfAndProviderOfViewModelProvider));
        }

        @Override
        public void inject(DocumentDataExtractorActivity documentDataExtractorActivity) {
            this.injectDocumentDataExtractorActivity(documentDataExtractorActivity);
        }

        private DocumentDataExtractorActivity injectDocumentDataExtractorActivity(DocumentDataExtractorActivity instance) {
            NFBaseActivity_MembersInjector.injectCameraUiSettings((NFBaseActivity)instance, (CameraUiSettings)((CameraUiSettings)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.cameraUiSettings())));
            BaseDocumentDataExtractorActivity_MembersInjector.injectFactory((BaseDocumentDataExtractorActivity)instance, (ViewModelProvider.Factory)((ViewModelProvider.Factory)this.bindViewModelFactoryProvider.get()));
            return instance;
        }

        private static final class DocumentDataExtractorProvider
        implements Provider<DocumentDataExtractor> {
            private final SDKUIComponent sDKUIComponent;

            DocumentDataExtractorProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public DocumentDataExtractor get() {
                return (DocumentDataExtractor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.documentDataExtractor());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }
    }
}

