/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.hicscanner.HealthInsuranceCardScanner;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.ui.di.components.HealthInsuranceCardCameraComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.HealthInsuranceCardCameraModule;
import io.scanbot.sdk.ui.di.modules.HealthInsuranceCardCameraModule_ProvideHealthInsuranceCardCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.PermissionsModule;
import io.scanbot.sdk.ui.di.modules.PermissionsModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui.view.base.NFBaseActivity;
import io.scanbot.sdk.ui.view.base.NFBaseActivity_MembersInjector;
import io.scanbot.sdk.ui.view.base.PermissionViewModel;
import io.scanbot.sdk.ui.view.hic.BaseHealthInsuranceCardScannerActivity;
import io.scanbot.sdk.ui.view.hic.BaseHealthInsuranceCardScannerActivity_MembersInjector;
import io.scanbot.sdk.ui.view.hic.HealthInsuranceCardCameraViewModel;
import io.scanbot.sdk.ui.view.hic.HealthInsuranceCardScannerActivity;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase_Factory;
import java.util.Map;

@DaggerGenerated
public final class DaggerHealthInsuranceCardCameraComponent {
    private DaggerHealthInsuranceCardCameraComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private HealthInsuranceCardCameraModule healthInsuranceCardCameraModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private PermissionsModule permissionsModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder healthInsuranceCardCameraModule(HealthInsuranceCardCameraModule healthInsuranceCardCameraModule) {
            this.healthInsuranceCardCameraModule = (HealthInsuranceCardCameraModule)Preconditions.checkNotNull((Object)healthInsuranceCardCameraModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder permissionsModule(PermissionsModule permissionsModule) {
            this.permissionsModule = (PermissionsModule)Preconditions.checkNotNull((Object)permissionsModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public HealthInsuranceCardCameraComponent build() {
            if (this.healthInsuranceCardCameraModule == null) {
                this.healthInsuranceCardCameraModule = new HealthInsuranceCardCameraModule();
            }
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.permissionsModule == null) {
                this.permissionsModule = new PermissionsModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new HealthInsuranceCardCameraComponentImpl(this.healthInsuranceCardCameraModule, this.viewModelFactoryModule, this.permissionsModule, this.sDKUIComponent);
        }
    }

    private static final class HealthInsuranceCardCameraComponentImpl
    implements HealthInsuranceCardCameraComponent {
        private final SDKUIComponent sDKUIComponent;
        private final HealthInsuranceCardCameraComponentImpl healthInsuranceCardCameraComponentImpl = this;
        Provider<HealthInsuranceCardScanner> ehicScannerProvider;
        Provider<ViewModel> provideHealthInsuranceCardCameraViewModelProvider;
        Provider<Context> provideContextProvider;
        Provider<CheckCameraPermissionUseCase> checkCameraPermissionUseCaseProvider;
        Provider<ViewModel> provideBarcodeCameraViewModelProvider;
        Provider mapOfClassOfAndProviderOfViewModelProvider;
        Provider<ViewModelProvider.Factory> bindViewModelFactoryProvider;

        HealthInsuranceCardCameraComponentImpl(HealthInsuranceCardCameraModule healthInsuranceCardCameraModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.sDKUIComponent = sDKUIComponentParam;
            this.initialize(healthInsuranceCardCameraModuleParam, viewModelFactoryModuleParam, permissionsModuleParam, sDKUIComponentParam);
        }

        private void initialize(HealthInsuranceCardCameraModule healthInsuranceCardCameraModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.ehicScannerProvider = new EhicScannerProvider(sDKUIComponentParam);
            this.provideHealthInsuranceCardCameraViewModelProvider = DoubleCheck.provider((Provider)HealthInsuranceCardCameraModule_ProvideHealthInsuranceCardCameraViewModelFactory.create(healthInsuranceCardCameraModuleParam, this.ehicScannerProvider));
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.checkCameraPermissionUseCaseProvider = CheckCameraPermissionUseCase_Factory.create(this.provideContextProvider);
            this.provideBarcodeCameraViewModelProvider = DoubleCheck.provider((Provider)PermissionsModule_ProvideBarcodeCameraViewModelFactory.create(permissionsModuleParam, this.checkCameraPermissionUseCaseProvider));
            this.mapOfClassOfAndProviderOfViewModelProvider = MapProviderFactory.builder((int)2).put(HealthInsuranceCardCameraViewModel.class, this.provideHealthInsuranceCardCameraViewModelProvider).put(PermissionViewModel.class, this.provideBarcodeCameraViewModelProvider).build();
            this.bindViewModelFactoryProvider = DoubleCheck.provider((Provider)ViewModelFactoryModule_BindViewModelFactoryFactory.create(viewModelFactoryModuleParam, (Provider<Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>>>)this.mapOfClassOfAndProviderOfViewModelProvider));
        }

        @Override
        public void inject(HealthInsuranceCardScannerActivity healthInsuranceCardScannerActivity) {
            this.injectHealthInsuranceCardScannerActivity(healthInsuranceCardScannerActivity);
        }

        private HealthInsuranceCardScannerActivity injectHealthInsuranceCardScannerActivity(HealthInsuranceCardScannerActivity instance) {
            NFBaseActivity_MembersInjector.injectCameraUiSettings((NFBaseActivity)instance, (CameraUiSettings)((CameraUiSettings)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.cameraUiSettings())));
            BaseHealthInsuranceCardScannerActivity_MembersInjector.injectFactory((BaseHealthInsuranceCardScannerActivity)instance, (ViewModelProvider.Factory)((ViewModelProvider.Factory)this.bindViewModelFactoryProvider.get()));
            return instance;
        }

        private static final class EhicScannerProvider
        implements Provider<HealthInsuranceCardScanner> {
            private final SDKUIComponent sDKUIComponent;

            EhicScannerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public HealthInsuranceCardScanner get() {
                return (HealthInsuranceCardScanner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.ehicScanner());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }
    }
}

