/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.core;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import io.scanbot.common.JsonKt;
import io.scanbot.sdk.common.ByteArrayJson;
import io.scanbot.sdk.common.ByteArrayJsonKt;
import io.scanbot.sdk.common.ImageSerializationMode;
import io.scanbot.sdk.core.BasicImageLoadOptions;
import io.scanbot.sdk.core.BufferImageLoadOptions;
import io.scanbot.sdk.core.BufferLoadMode;
import io.scanbot.sdk.core.EncodeImageOptions;
import io.scanbot.sdk.core.ImageInfo;
import io.scanbot.sdk.core.PathImageLoadOptions;
import io.scanbot.sdk.core.RawImageLoadOptions;
import io.scanbot.sdk.core.SaveImageOptions;
import io.scanbot.sdk.persistence.fileio.CoreStreamProvider;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 02\u00020\u00012\u00060\u0002j\u0002`\u0003:\u00010B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0000H\u0086 J\t\u0010\u0013\u001a\u00020\u0014H\u0086 J\u0006\u0010\u0015\u001a\u00020\u0014J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0086 J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0086 J\u001b\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0086 J\u0013\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\u001d\u001a\u00020!H\u0086 J\b\u0010\"\u001a\u00020\u0014H\u0002J\b\u0010#\u001a\u00020\u0014H\u0002J\b\u0010$\u001a\u00020\u0014H\u0016J\b\u0010%\u001a\u00020\u0014H\u0004J\b\u0010&\u001a\u00020\u000eH\u0016J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000eH\u0016J\u0006\u0010+\u001a\u00020\u001cJ\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/R\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00061"}, d2={"Lio/scanbot/sdk/core/ImageRef;", "Landroid/os/Parcelable;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "uniqueId", "Ljava/util/UUID;", "acquireStrongReference", "", "<init>", "(Ljava/util/UUID;Z)V", "value", "getUniqueId", "()Ljava/util/UUID;", "hashCode", "", "equals", "other", "", "clone", "hibernate", "", "clear", "info", "Lio/scanbot/sdk/core/ImageInfo;", "toBitmap", "Landroid/graphics/Bitmap;", "saveImage", "path", "", "options", "Lio/scanbot/sdk/core/SaveImageOptions;", "encodeImage", "", "Lio/scanbot/sdk/core/EncodeImageOptions;", "acquireSerializedReference", "upgradeSerializedReference", "close", "finalize", "describeContents", "writeToParcel", "parcel", "Landroid/os/Parcel;", "flags", "serialize", "toJson", "Lorg/json/JSONObject;", "imageSerializationMode", "Lio/scanbot/sdk/common/ImageSerializationMode;", "CREATOR", "core-common_release"})
public final class ImageRef
implements Parcelable,
AutoCloseable {
    @NotNull
    public static final CREATOR CREATOR = new CREATOR(null);
    @NotNull
    private static final UUID INVALID_UNIQUE_ID = new UUID(0L, 0L);
    @Nullable
    private UUID uniqueId;

    /*
     * WARNING - void declaration
     */
    public ImageRef(@NotNull UUID uniqueId, boolean acquireStrongReference) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"uniqueId");
        ((ImageRef)this).uniqueId = var1_1;
        if (Intrinsics.areEqual((Object)uniqueId, (Object)INVALID_UNIQUE_ID)) {
            ((ImageRef)this).uniqueId = null;
        }
        if ((this = ((ImageRef)this).uniqueId) != null && var2_2 != false) {
            Object object = this;
            Intrinsics.checkNotNull((Object)object);
            io.scanbot.sdk.core.ImageRef$CREATOR.access$acquireStrongReference(CREATOR, (UUID)object);
        }
    }

    public static /* synthetic */ boolean saveImage$default(ImageRef imageRef, String string, SaveImageOptions saveImageOptions, int n, Object object) {
        if ((n & 2) != 0) {
            SaveImageOptions saveImageOptions2;
            saveImageOptions = saveImageOptions2;
            saveImageOptions2 = new SaveImageOptions(0, null, 3, null);
        }
        return imageRef.saveImage(string, saveImageOptions);
    }

    public static /* synthetic */ byte[] encodeImage$default(ImageRef imageRef, EncodeImageOptions encodeImageOptions, int n, Object object) {
        if ((n & 1) != 0) {
            EncodeImageOptions encodeImageOptions2;
            encodeImageOptions = encodeImageOptions2;
            encodeImageOptions2 = new EncodeImageOptions(0, null, 3, null);
        }
        return imageRef.encodeImage(encodeImageOptions);
    }

    private final void acquireSerializedReference() {
        UUID uUID = this.uniqueId;
        Intrinsics.checkNotNull((Object)uUID);
        CREATOR.acquireSerializedReference(uUID);
    }

    private final void upgradeSerializedReference() {
        UUID uUID = this.uniqueId;
        Intrinsics.checkNotNull((Object)uUID);
        CREATOR.upgradeSerializedReference(uUID);
    }

    @JvmStatic
    public static final native void releaseAllImages();

    @JvmStatic
    @Nullable
    public static final native ImageRef fromEncodedBuffer(@NotNull byte[] var0, @NotNull BufferImageLoadOptions var1);

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final ImageRef fromInputStream(@NotNull InputStream inputStream, @NotNull BufferImageLoadOptions options) {
        void var1_1;
        InputStream inputStream2;
        return CREATOR.fromInputStream(inputStream2, (BufferImageLoadOptions)var1_1);
    }

    @JvmStatic
    @Nullable
    public static final native ImageRef fromPath(@NotNull String var0, @NotNull PathImageLoadOptions var1);

    @JvmStatic
    @NotNull
    public static final native ImageRef fromBitmap(@NotNull Bitmap var0, @NotNull BasicImageLoadOptions var1);

    @JvmStatic
    @NotNull
    public static final native ImageRef fromNv21(@NotNull byte[] var0, int var1, int var2, @NotNull RawImageLoadOptions var3);

    @JvmStatic
    @NotNull
    public static final ImageRef deserialize(@NotNull String source) {
        String string;
        return CREATOR.deserialize(string);
    }

    @JvmStatic
    @NotNull
    public static final ImageRef fromSerializedReference(@NotNull UUID uniqueId) {
        UUID uUID;
        return CREATOR.fromSerializedReference(uUID);
    }

    @JvmStatic
    @NotNull
    public static final ImageRef fromJson(@NotNull Map<String, ? extends Object> source) {
        Map<String, ? extends Object> map;
        return CREATOR.fromJson(map);
    }

    @JvmStatic
    @NotNull
    public static final ImageRef fromJson(@NotNull JSONObject source) {
        JSONObject jSONObject;
        return CREATOR.fromJson(jSONObject);
    }

    @JvmStatic
    public static final native void setHibernationJpegQuality(int var0);

    @JvmStatic
    public static final native void setHibernationCacheDirPath(@Nullable String var0);

    @JvmStatic
    public static final native void setStorageCryptingProvider(@Nullable CoreStreamProvider var0);

    @JvmStatic
    public static final native boolean acquireSerializedReference(@NotNull UUID var0);

    @JvmStatic
    public static final native boolean releaseStrongReference(@NotNull UUID var0);

    @JvmStatic
    public static final native boolean upgradeSerializedReference(@NotNull UUID var0);

    @JvmStatic
    private static final native boolean acquireStrongReference(UUID var0);

    @JvmStatic
    private static final native void clear(UUID var0);

    @Nullable
    public final UUID getUniqueId() {
        return this.uniqueId;
    }

    public int hashCode() {
        UUID this_ = ((ImageRef)((Object)this_)).uniqueId;
        return this_ != null ? ((Object)this_).hashCode() : 0;
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        UUID uUID = ((ImageRef)((Object)uUID)).uniqueId;
        object = other instanceof ImageRef ? (ImageRef)object : null;
        object = object != null ? ((ImageRef)object).uniqueId : null;
        return Intrinsics.areEqual((Object)uUID, (Object)object);
    }

    @Nullable
    public final native ImageRef clone();

    public final native void hibernate();

    public final void clear() {
        UUID uUID = this.uniqueId;
        Intrinsics.checkNotNull((Object)uUID);
        io.scanbot.sdk.core.ImageRef$CREATOR.access$clear(CREATOR, uUID);
        this.close();
    }

    @Nullable
    public final native ImageInfo info();

    @Nullable
    public final native Bitmap toBitmap();

    public final native boolean saveImage(@NotNull String var1, @NotNull SaveImageOptions var2);

    @NotNull
    public final native byte[] encodeImage(@NotNull EncodeImageOptions var1);

    @Override
    public void close() {
        UUID uUID = this.uniqueId;
        if (uUID == null) {
            return;
        }
        UUID uUID2 = uUID;
        Intrinsics.checkNotNull((Object)uUID2);
        CREATOR.releaseStrongReference(uUID2);
        this.uniqueId = null;
    }

    public final void finalize() {
        if (this.uniqueId != null) {
            LoggerProvider.getLogger().d("ScanbotSDK", "ImageRef with unique ID " + this.uniqueId + " was closed by the finalizer. Calling ImageRef.close() as soon as the ImageRef is no longer needed may significantly reduce app memory usage.");
        }
        this.close();
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"parcel");
        parcel.writeString(this.serialize());
    }

    @NotNull
    public final String serialize() {
        if (this.uniqueId == null) {
            String string = INVALID_UNIQUE_ID.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        ImageRef imageRef = this;
        imageRef.acquireSerializedReference();
        return String.valueOf(imageRef.uniqueId);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final JSONObject toJson(@NotNull ImageSerializationMode imageSerializationMode) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)imageSerializationMode), (String)"imageSerializationMode");
        int n = WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()];
        if (n != 1) {
            JSONObject jSONObject;
            if (n != 2) throw new NoWhenBranchMatchedException();
            ImageRef imageRef = this;
            JSONObject jSONObject2 = jSONObject;
            jSONObject2();
            jSONObject.put("buffer", (Object)ByteArrayJsonKt.toBase64(ImageRef.encodeImage$default((ImageRef)this, null, 1, null)));
            this = "imageInfo";
            Object object = imageRef.info();
            if (object == null || (object = ImageInfo.toJson$default((ImageInfo)object, null, 1, null)) == null) {
                object = JSONObject.NULL;
            }
            this = jSONObject2.put((String)this, object);
            Intrinsics.checkNotNull((Object)this);
            return this;
        } else {
            this = new JSONObject().put("uniqueId", (Object)((ImageRef)this).serialize());
            Intrinsics.checkNotNull((Object)this);
        }
        return this;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u001d\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u000f\u001a\u00020\u0010H\u0087 J\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0087 J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J\u001d\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u0014\u001a\u00020\u001cH\u0087 J\u001b\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u0014\u001a\u00020 H\u0087 J+\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020%H\u0087 J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u001bH\u0007J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0006H\u0007J\u001e\u0010*\u001a\u00020\u00022\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010,0+H\u0007J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010'\u001a\u00020-H\u0007J\u0011\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\rH\u0087 J\u0013\u00100\u001a\u00020\u00102\b\u00101\u001a\u0004\u0018\u00010\u001bH\u0087 J\u0013\u00102\u001a\u00020\u00102\b\u00103\u001a\u0004\u0018\u000104H\u0087 J\u0011\u00105\u001a\u0002062\u0006\u0010)\u001a\u00020\u0006H\u0087 J\u0011\u00107\u001a\u0002062\u0006\u0010)\u001a\u00020\u0006H\u0087 J\u0011\u00108\u001a\u0002062\u0006\u0010)\u001a\u00020\u0006H\u0087 J\u0011\u00109\u001a\u0002062\u0006\u0010)\u001a\u00020\u0006H\u0083 J\u0011\u0010:\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0006H\u0083 R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lio/scanbot/sdk/core/ImageRef$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lio/scanbot/sdk/core/ImageRef;", "<init>", "()V", "INVALID_UNIQUE_ID", "Ljava/util/UUID;", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lio/scanbot/sdk/core/ImageRef;", "releaseAllImages", "", "fromEncodedBuffer", "encodedBuffer", "", "options", "Lio/scanbot/sdk/core/BufferImageLoadOptions;", "fromInputStream", "inputStream", "Ljava/io/InputStream;", "fromPath", "path", "", "Lio/scanbot/sdk/core/PathImageLoadOptions;", "fromBitmap", "bitmap", "Landroid/graphics/Bitmap;", "Lio/scanbot/sdk/core/BasicImageLoadOptions;", "fromNv21", "nv21", "width", "height", "Lio/scanbot/sdk/core/RawImageLoadOptions;", "deserialize", "source", "fromSerializedReference", "uniqueId", "fromJson", "", "", "Lorg/json/JSONObject;", "setHibernationJpegQuality", "quality", "setHibernationCacheDirPath", "cacheDirPath", "setStorageCryptingProvider", "storageCryptingProvider", "Lio/scanbot/sdk/persistence/fileio/CoreStreamProvider;", "acquireSerializedReference", "", "releaseStrongReference", "upgradeSerializedReference", "acquireStrongReference", "clear", "core-common_release"})
    public static final class CREATOR
    implements Parcelable.Creator<ImageRef> {
        private CREATOR() {
        }

        public static /* synthetic */ ImageRef fromEncodedBuffer$default(CREATOR cREATOR, byte[] byArray, BufferImageLoadOptions bufferImageLoadOptions, int n, Object object) {
            if ((n & 2) != 0) {
                BufferImageLoadOptions bufferImageLoadOptions2;
                bufferImageLoadOptions = bufferImageLoadOptions2;
                bufferImageLoadOptions2 = new BufferImageLoadOptions(null, null, 3, null);
            }
            return cREATOR.fromEncodedBuffer(byArray, bufferImageLoadOptions);
        }

        public static /* synthetic */ ImageRef fromInputStream$default(CREATOR cREATOR, InputStream inputStream, BufferImageLoadOptions bufferImageLoadOptions, int n, Object object) {
            if ((n & 2) != 0) {
                BufferImageLoadOptions bufferImageLoadOptions2;
                bufferImageLoadOptions = bufferImageLoadOptions2;
                bufferImageLoadOptions2 = new BufferImageLoadOptions(null, null, 3, null);
            }
            return cREATOR.fromInputStream(inputStream, bufferImageLoadOptions);
        }

        public static /* synthetic */ ImageRef fromPath$default(CREATOR cREATOR, String string, PathImageLoadOptions pathImageLoadOptions, int n, Object object) {
            if ((n & 2) != 0) {
                PathImageLoadOptions pathImageLoadOptions2;
                pathImageLoadOptions = pathImageLoadOptions2;
                pathImageLoadOptions2 = new PathImageLoadOptions(null, null, null, 7, null);
            }
            return cREATOR.fromPath(string, pathImageLoadOptions);
        }

        public static /* synthetic */ ImageRef fromBitmap$default(CREATOR cREATOR, Bitmap bitmap, BasicImageLoadOptions basicImageLoadOptions, int n, Object object) {
            if ((n & 2) != 0) {
                BasicImageLoadOptions basicImageLoadOptions2;
                basicImageLoadOptions = basicImageLoadOptions2;
                basicImageLoadOptions2 = new BasicImageLoadOptions(null, 1, null);
            }
            return cREATOR.fromBitmap(bitmap, basicImageLoadOptions);
        }

        public static /* synthetic */ ImageRef fromNv21$default(CREATOR cREATOR, byte[] byArray, int n, int n2, RawImageLoadOptions rawImageLoadOptions, int n3, Object object) {
            if ((n3 & 8) != 0) {
                RawImageLoadOptions rawImageLoadOptions2;
                rawImageLoadOptions = rawImageLoadOptions2;
                rawImageLoadOptions2 = new RawImageLoadOptions(null, null, 3, null);
            }
            return cREATOR.fromNv21(byArray, n, n2, rawImageLoadOptions);
        }

        @JvmStatic
        private final boolean acquireStrongReference(UUID uniqueId) {
            return ImageRef.acquireStrongReference(uniqueId);
        }

        @JvmStatic
        private final void clear(UUID uniqueId) {
            ImageRef.clear(uniqueId);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ boolean access$acquireStrongReference(CREATOR $this, UUID uniqueId) {
            void var1_1;
            return $this.acquireStrongReference((UUID)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ void access$clear(CREATOR $this, UUID uniqueId) {
            void var1_1;
            $this.clear((UUID)var1_1);
        }

        public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public ImageRef createFromParcel(@NotNull Parcel parcel) {
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)v0, (String)"parcel");
            String string = v0.readString();
            Intrinsics.checkNotNull((Object)string);
            return this.deserialize(string);
        }

        @NotNull
        public ImageRef[] newArray(int size) {
            return new ImageRef[size];
        }

        @JvmStatic
        public final void releaseAllImages() {
            ImageRef.releaseAllImages();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final ImageRef fromEncodedBuffer(@NotNull byte[] encodedBuffer, @NotNull BufferImageLoadOptions options) {
            void var2_2;
            return ImageRef.fromEncodedBuffer(encodedBuffer, (BufferImageLoadOptions)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final ImageRef fromInputStream(@NotNull InputStream inputStream, @NotNull BufferImageLoadOptions options) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"options");
            return this.fromEncodedBuffer(ByteStreamsKt.readBytes((InputStream)var1_1), (BufferImageLoadOptions)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final ImageRef fromPath(@NotNull String path, @NotNull PathImageLoadOptions options) {
            void var2_2;
            return ImageRef.fromPath(path, (PathImageLoadOptions)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ImageRef fromBitmap(@NotNull Bitmap bitmap, @NotNull BasicImageLoadOptions options) {
            void var2_2;
            return ImageRef.fromBitmap(bitmap, (BasicImageLoadOptions)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ImageRef fromNv21(@NotNull byte[] nv21, int width, int height, @NotNull RawImageLoadOptions options) {
            void var4_4;
            void var3_3;
            void var2_2;
            return ImageRef.fromNv21(nv21, (int)var2_2, (int)var3_3, (RawImageLoadOptions)var4_4);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ImageRef deserialize(@NotNull String source) {
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)v0, (String)"source");
            UUID uUID = UUID.fromString((String)v0);
            Intrinsics.checkNotNull((Object)uUID);
            return this.fromSerializedReference(uUID);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ImageRef fromSerializedReference(@NotNull UUID uniqueId) {
            void var1_1;
            ImageRef imageRef;
            Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
            ImageRef imageRef2 = imageRef;
            if (new ImageRef((UUID)var1_1, false).getUniqueId() != null) {
                imageRef2.upgradeSerializedReference();
            }
            return imageRef2;
        }

        @JvmStatic
        @NotNull
        public final ImageRef fromJson(@NotNull Map<String, ? extends Object> source) {
            Map<String, ? extends Object> map = source;
            Intrinsics.checkNotNullParameter(map, (String)"source");
            if (map.containsKey("buffer")) {
                Object object = MapsKt.getValue((Map)var1_1, (Object)"buffer");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                this = ((CREATOR)this).fromEncodedBuffer(ByteArrayJson.INSTANCE.fromBase64((String)object), new BufferImageLoadOptions(null, BufferLoadMode.LAZY, 1, null));
                Intrinsics.checkNotNull((Object)this);
            } else {
                Object object = MapsKt.getValue((Map)var1_1, (Object)"uniqueId");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                this = ((CREATOR)this).deserialize((String)object);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ImageRef fromJson(@NotNull JSONObject source) {
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)v0, (String)"source");
            return this.fromJson(JsonKt.toMap((JSONObject)v0));
        }

        @JvmStatic
        public final void setHibernationJpegQuality(int quality) {
            ImageRef.setHibernationJpegQuality(quality);
        }

        @JvmStatic
        public final void setHibernationCacheDirPath(@Nullable String cacheDirPath) {
            ImageRef.setHibernationCacheDirPath(cacheDirPath);
        }

        @JvmStatic
        public final void setStorageCryptingProvider(@Nullable CoreStreamProvider storageCryptingProvider) {
            ImageRef.setStorageCryptingProvider(storageCryptingProvider);
        }

        @JvmStatic
        public final boolean acquireSerializedReference(@NotNull UUID uniqueId) {
            return ImageRef.acquireSerializedReference(uniqueId);
        }

        @JvmStatic
        public final boolean releaseStrongReference(@NotNull UUID uniqueId) {
            return ImageRef.releaseStrongReference(uniqueId);
        }

        @JvmStatic
        public final boolean upgradeSerializedReference(@NotNull UUID uniqueId) {
            return ImageRef.upgradeSerializedReference(uniqueId);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageSerializationMode.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[ImageSerializationMode.REFERENCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[ImageSerializationMode.BUFFER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

