/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.shoeboxed;

import io.scanbot.shoeboxed.ApiApplication;
import io.scanbot.shoeboxed.OAuthService;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.RetrofitError;

class OAuthServiceProvider {
    private static final String ENDPOINT = "https://id.shoeboxed.com";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String BASIC_PREFIX = "Basic ";
    private OAuthService service;
    private String baseCredentials;
    private String endpoint;

    static OAuthServiceProvider forApplication(ApiApplication application) {
        return OAuthServiceProvider.forApplicationWithEndpoint(application, ENDPOINT);
    }

    static OAuthServiceProvider forApplicationWithEndpoint(ApiApplication application, String endpoint) {
        OAuthServiceProvider provider = new OAuthServiceProvider();
        provider.endpoint = endpoint;
        String credentials = application.getId() + ":" + application.getSecret();
        provider.baseCredentials = new String(Base64.encodeBase64((byte[])credentials.getBytes()));
        RestAdapter.Builder builder = new RestAdapter.Builder().setEndpoint(endpoint);
        OAuthServiceProvider oAuthServiceProvider = provider;
        oAuthServiceProvider.getClass();
        RestAdapter.Builder builder2 = builder.setRequestInterceptor((RequestInterceptor)oAuthServiceProvider.new RequestInterceptorImpl());
        OAuthServiceProvider oAuthServiceProvider2 = provider;
        oAuthServiceProvider2.getClass();
        RestAdapter adapter = builder2.setErrorHandler((ErrorHandler)oAuthServiceProvider2.new ErrorHandlerImpl()).build();
        provider.service = (OAuthService)adapter.create(OAuthService.class);
        return provider;
    }

    OAuthServiceProvider() {
    }

    OAuthService getService() {
        return this.service;
    }

    String getEndpoint() {
        return this.endpoint;
    }

    private class ErrorHandlerImpl
    implements ErrorHandler {
        private ErrorHandlerImpl() {
        }

        public Throwable handleError(RetrofitError cause) {
            return new IOException((Throwable)cause);
        }
    }

    private class RequestInterceptorImpl
    implements RequestInterceptor {
        private RequestInterceptorImpl() {
        }

        public void intercept(RequestInterceptor.RequestFacade request) {
            request.addHeader(OAuthServiceProvider.HEADER_AUTHORIZATION, OAuthServiceProvider.BASIC_PREFIX + OAuthServiceProvider.this.baseCredentials);
        }
    }
}

