/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.shoeboxed;

import io.scanbot.shoeboxed.ShoeboxedRestService;
import io.scanbot.shoeboxed.ShoeboxedSession;
import io.scanbot.shoeboxed.UnauthorizedException;
import java.io.IOException;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.RetrofitError;

class RestServiceProvider {
    private static final String ENDPOINT = "https://api.shoeboxed.com:443/v2";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_AUTHORIZATION_VALUE = "Bearer %s";
    private static final int HTTP_UNAUTHORIZED = 401;
    private ShoeboxedSession session;
    private ShoeboxedRestService restService;

    static RestServiceProvider forSession(ShoeboxedSession session) {
        return RestServiceProvider.forSessionWithEndpoint(session, ENDPOINT);
    }

    static RestServiceProvider forSessionWithEndpoint(ShoeboxedSession session, String endpoint) {
        RestServiceProvider serviceProvider = new RestServiceProvider();
        RestAdapter.Builder builder = new RestAdapter.Builder().setEndpoint(endpoint);
        RestServiceProvider restServiceProvider = serviceProvider;
        restServiceProvider.getClass();
        RestAdapter.Builder builder2 = builder.setRequestInterceptor((RequestInterceptor)restServiceProvider.new RequestInterceptorImpl());
        RestServiceProvider restServiceProvider2 = serviceProvider;
        restServiceProvider2.getClass();
        RestAdapter adapter = builder2.setErrorHandler((ErrorHandler)restServiceProvider2.new ErrorHandlerImpl()).build();
        serviceProvider.session = session;
        serviceProvider.restService = (ShoeboxedRestService)adapter.create(ShoeboxedRestService.class);
        return serviceProvider;
    }

    RestServiceProvider() {
    }

    ShoeboxedRestService getService() {
        return this.restService;
    }

    private class ErrorHandlerImpl
    implements ErrorHandler {
        private ErrorHandlerImpl() {
        }

        public Throwable handleError(RetrofitError cause) {
            switch (cause.getResponse().getStatus()) {
                case 401: {
                    try {
                        RestServiceProvider.this.session.refreshAccessToken();
                        return new UnauthorizedException(cause);
                    }
                    catch (IOException e) {
                        return new UnauthorizedException(cause);
                    }
                }
            }
            return new IOException((Throwable)cause);
        }
    }

    private class RequestInterceptorImpl
    implements RequestInterceptor {
        private RequestInterceptorImpl() {
        }

        public void intercept(RequestInterceptor.RequestFacade requestFacade) {
            try {
                String accessToken = RestServiceProvider.this.session.getAccessToken();
                requestFacade.addHeader(RestServiceProvider.HEADER_AUTHORIZATION, String.format(RestServiceProvider.HEADER_AUTHORIZATION_VALUE, accessToken));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

