/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.shoeboxed;

import io.scanbot.shoeboxed.RestServiceProvider;
import io.scanbot.shoeboxed.ShoeboxedRestService;
import io.scanbot.shoeboxed.ShoeboxedSession;
import io.scanbot.shoeboxed.UnauthorizedException;
import io.scanbot.shoeboxed.entity.Account;
import io.scanbot.shoeboxed.entity.Category;
import io.scanbot.shoeboxed.entity.Document;
import io.scanbot.shoeboxed.entity.request.CreateCategoryRequest;
import io.scanbot.shoeboxed.entity.request.CreateDocumentRequest;
import java.io.IOException;
import java.util.List;
import retrofit.mime.TypedFile;

public class ShoeboxedApi {
    private final ShoeboxedRestService restService;

    public static ShoeboxedApi forSession(ShoeboxedSession shoeboxedSession) {
        return new ShoeboxedApi(RestServiceProvider.forSession(shoeboxedSession).getService());
    }

    static ShoeboxedApi forServiceProvider(RestServiceProvider restServiceProvider) {
        return new ShoeboxedApi(restServiceProvider.getService());
    }

    ShoeboxedApi(ShoeboxedRestService restService) {
        this.restService = restService;
    }

    public List<Account> getAccounts() throws IOException {
        try {
            return this.restService.getAccounts().list();
        }
        catch (UnauthorizedException e) {
            return this.restService.getAccounts().list();
        }
    }

    public List<Category> getCategories(long accountId) throws IOException {
        try {
            return this.restService.getCategories(accountId).list();
        }
        catch (UnauthorizedException e) {
            return this.restService.getCategories(accountId).list();
        }
    }

    public Category createCategory(long accountId, CreateCategoryRequest request) throws IOException {
        try {
            return this.restService.createCategory(accountId, request);
        }
        catch (UnauthorizedException e) {
            return this.restService.createCategory(accountId, request);
        }
    }

    public Document createDocument(long accountId, TypedFile file, CreateDocumentRequest request) throws IOException {
        try {
            return this.restService.createDocument(accountId, file, request);
        }
        catch (UnauthorizedException e) {
            return this.restService.createDocument(accountId, file, request);
        }
    }

    public void deleteDocument(long accountId, String documentId) throws IOException {
        try {
            this.restService.deleteDocument(accountId, documentId);
        }
        catch (UnauthorizedException e) {
            this.restService.deleteDocument(accountId, documentId);
        }
    }
}

