/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.shoeboxed;

import io.scanbot.shoeboxed.ApiApplication;
import io.scanbot.shoeboxed.OAuthService;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class OAuthServiceProvider {
    private static final String ENDPOINT = "https://id.shoeboxed.com";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String BASIC_PREFIX = "Basic ";
    private OAuthService service;
    private String baseCredentials;
    private String endpoint;

    static OAuthServiceProvider forApplication(ApiApplication application) {
        return OAuthServiceProvider.forApplicationWithEndpoint(application, ENDPOINT, new OkHttpClient());
    }

    static OAuthServiceProvider forApplicationWithEndpoint(ApiApplication application, String endpoint, OkHttpClient okHttpClient) {
        OAuthServiceProvider provider = new OAuthServiceProvider();
        provider.endpoint = endpoint;
        String credentials = application.getId() + ":" + application.getSecret();
        provider.baseCredentials = new String(Base64.encodeBase64((byte[])credentials.getBytes()));
        Retrofit.Builder builder = new Retrofit.Builder().baseUrl(endpoint).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        OkHttpClient.Builder builder2 = okHttpClient.newBuilder();
        OAuthServiceProvider oAuthServiceProvider = provider;
        oAuthServiceProvider.getClass();
        Retrofit adapter = builder.client(builder2.addInterceptor((Interceptor)oAuthServiceProvider.new HeaderInterceptor()).addInterceptor((Interceptor)new ErrorHandler()).build()).build();
        provider.service = (OAuthService)adapter.create(OAuthService.class);
        return provider;
    }

    OAuthServiceProvider() {
    }

    OAuthService getService() {
        return this.service;
    }

    String getEndpoint() {
        return this.endpoint;
    }

    private class HeaderInterceptor
    implements Interceptor {
        private HeaderInterceptor() {
        }

        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            Request original = chain.request();
            Request request = original.newBuilder().header(OAuthServiceProvider.HEADER_AUTHORIZATION, OAuthServiceProvider.BASIC_PREFIX + OAuthServiceProvider.this.baseCredentials).build();
            return chain.proceed(request);
        }
    }

    private static class ErrorHandler
    implements Interceptor {
        private ErrorHandler() {
        }

        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Response original = chain.proceed(request);
            if (!original.isSuccessful() || original.body() == null) {
                throw new IOException();
            }
            return original;
        }
    }
}

