/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.shoeboxed;

import io.scanbot.shoeboxed.UnauthorizedException;
import io.scanbot.shoeboxed.entity.Category;
import io.scanbot.shoeboxed.entity.Document;
import io.scanbot.shoeboxed.entity.container.Accounts;
import io.scanbot.shoeboxed.entity.container.Categories;
import io.scanbot.shoeboxed.entity.request.CreateCategoryRequest;
import io.scanbot.shoeboxed.entity.request.CreateDocumentRequest;
import java.io.IOException;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;

interface ShoeboxedRestService {
    @GET(value="/user/accounts")
    public Call<Accounts> getAccounts() throws UnauthorizedException, IOException;

    @GET(value="/accounts/{account}/categories")
    public Call<Categories> getCategories(@Path(value="account") long var1) throws UnauthorizedException, IOException;

    @POST(value="/accounts/{account}/categories")
    public Call<Category> createCategory(@Path(value="account") long var1, @Body CreateCategoryRequest var3) throws UnauthorizedException, IOException;

    @Multipart
    @POST(value="/accounts/{account}/documents")
    public Call<Document> createDocument(@Path(value="account") RequestBody var1, @Part(value="attachment") MultipartBody.Part var2, @Part(value="document") CreateDocumentRequest var3) throws UnauthorizedException, IOException;

    @DELETE(value="/accounts/{account}/documents/{id}")
    public Call<Void> deleteDocument(@Path(value="account") long var1, @Path(value="id") String var3) throws UnauthorizedException, IOException;
}

