/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.shoeboxed;

import com.google.gson.annotations.SerializedName;
import io.scanbot.shoeboxed.ApiApplication;
import io.scanbot.shoeboxed.OAuthService;
import io.scanbot.shoeboxed.OAuthServiceProvider;
import io.scanbot.shoeboxed.util.UrlUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class AuthHandler {
    private String lastGeneratedState;
    private final ApiApplication application;
    private final OAuthService oAuthService;
    private final String endpoint;

    public static AuthHandler forApplication(ApiApplication apiApplication) {
        return AuthHandler.forServiceProvider(apiApplication, OAuthServiceProvider.forApplication(apiApplication));
    }

    static AuthHandler forServiceProvider(ApiApplication application, OAuthServiceProvider serviceProvider) {
        return new AuthHandler(application, serviceProvider.getService(), serviceProvider.getEndpoint());
    }

    AuthHandler(ApiApplication application, OAuthService oAuthService, String endpoint) {
        this.application = application;
        this.oAuthService = oAuthService;
        this.endpoint = endpoint;
    }

    public synchronized String generateAuthorizationUrl(Scope scope) {
        this.regenerateState();
        return String.format(this.endpoint + "/oauth/authorize?client_id=%s&response_type=code&scope=%s&redirect_uri=%s&state=%s", this.application.getId(), scope.toString(), this.application.getRedirectUri(), this.lastGeneratedState);
    }

    private void regenerateState() {
        this.lastGeneratedState = UUID.randomUUID().toString();
    }

    public synchronized Tokens getTokens(String url) throws MalformedURLException, IOException {
        Map<String, List<String>> params = UrlUtils.getQueryParams(url);
        if (!params.containsKey("code") || !params.containsKey("state")) {
            throw new MalformedURLException();
        }
        String authCode = params.get("code").get(0);
        String state = params.get("state").get(0);
        return this.getTokensFromAuthorizationCode(authCode, state);
    }

    synchronized Tokens getTokensFromAuthorizationCode(String authCode, String state) throws StateMismatchException, IOException {
        if (this.lastGeneratedState == null || !this.lastGeneratedState.equals(state)) {
            throw new StateMismatchException();
        }
        return (Tokens)this.oAuthService.getTokensFromAuthorizationCode(authCode, "authorization_code", this.application.getRedirectUri()).execute().body();
    }

    public synchronized Tokens refreshTokens(String refreshToken) throws IOException {
        throw new IOException("Not supported");
    }

    public static class StateMismatchException
    extends IOException {
    }

    public static enum Scope {
        ALL{

            public String toString() {
                return "all";
            }
        };

    }

    public static final class Tokens
    implements Serializable {
        @SerializedName(value="access_token")
        private final String accessToken;
        @SerializedName(value="refresh_token")
        private final String refreshToken;

        public Tokens(String accessToken, String refreshToken) {
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }
    }
}

