/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.shoeboxed.entity.request;

import io.scanbot.shoeboxed.entity.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class CreateDocumentRequest {
    private final List<String> categories;
    private final Document.ProcessingState processingState;
    private final Document.Type type;
    private final String notes;
    private final String city;

    CreateDocumentRequest(Builder builder) {
        this.categories = builder.categories;
        this.processingState = builder.processingState;
        this.type = builder.type;
        this.notes = builder.notes;
        this.city = builder.city;
    }

    public static class Builder {
        private final List<String> categories = new ArrayList<String>();
        private Document.ProcessingState processingState = Document.ProcessingState.NEEDS_USER_PROCESSING;
        private Document.Type type = Document.Type.OTHER;
        private String notes;
        private String city;

        public Builder appendCategories(Collection<String> categories) {
            this.categories.addAll(categories);
            return this;
        }

        public Builder appendCategory(String category) {
            this.categories.add(category);
            return this;
        }

        public Builder processingState(Document.ProcessingState state) {
            this.processingState = state;
            return this;
        }

        public Builder type(Document.Type type) {
            this.type = type;
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            return this;
        }

        public CreateDocumentRequest build() {
            return new CreateDocumentRequest(this);
        }
    }
}

