/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.shoeboxed;

import io.scanbot.shoeboxed.ShoeboxedRestService;
import io.scanbot.shoeboxed.ShoeboxedSession;
import io.scanbot.shoeboxed.UnauthorizedException;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class RestServiceProvider {
    private static final String ENDPOINT = "https://api.shoeboxed.com:443/v2/";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_AUTHORIZATION_VALUE = "Bearer %s";
    private static final int HTTP_UNAUTHORIZED = 401;
    private ShoeboxedSession session;
    private ShoeboxedRestService restService;

    static RestServiceProvider forSession(ShoeboxedSession session) {
        return RestServiceProvider.forSessionWithEndpoint(session, ENDPOINT);
    }

    static RestServiceProvider forSessionWithEndpoint(ShoeboxedSession session, String endpoint) {
        RestServiceProvider serviceProvider = new RestServiceProvider();
        Retrofit.Builder builder = new Retrofit.Builder().baseUrl(endpoint).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        OkHttpClient.Builder builder2 = session.getOkHttpClient().newBuilder();
        RestServiceProvider restServiceProvider = serviceProvider;
        restServiceProvider.getClass();
        OkHttpClient.Builder builder3 = builder2.addInterceptor((Interceptor)restServiceProvider.new HeaderInterceptor());
        RestServiceProvider restServiceProvider2 = serviceProvider;
        restServiceProvider2.getClass();
        Retrofit adapter = builder.client(builder3.addInterceptor((Interceptor)restServiceProvider2.new ErrorHandler()).build()).build();
        serviceProvider.session = session;
        serviceProvider.restService = (ShoeboxedRestService)adapter.create(ShoeboxedRestService.class);
        return serviceProvider;
    }

    RestServiceProvider() {
    }

    ShoeboxedRestService getService() {
        return this.restService;
    }

    private class ErrorHandler
    implements Interceptor {
        private ErrorHandler() {
        }

        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Response original = chain.proceed(request);
            if (!original.isSuccessful() || original.body() == null) {
                throw new IOException();
            }
            if (original.code() == 401) {
                try {
                    RestServiceProvider.this.session.refreshAccessToken();
                    throw new UnauthorizedException();
                }
                catch (IOException e) {
                    throw new UnauthorizedException();
                }
            }
            return original;
        }
    }

    private class HeaderInterceptor
    implements Interceptor {
        private HeaderInterceptor() {
        }

        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            Request original = chain.request();
            String accessToken = RestServiceProvider.this.session.getAccessToken();
            Request request = original.newBuilder().header(RestServiceProvider.HEADER_AUTHORIZATION, String.format(RestServiceProvider.HEADER_AUTHORIZATION_VALUE, accessToken)).build();
            return chain.proceed(request);
        }
    }
}

