/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.shoeboxed;

import io.scanbot.shoeboxed.ApiApplication;
import io.scanbot.shoeboxed.AuthHandler;
import java.io.IOException;
import okhttp3.OkHttpClient;

public class ShoeboxedSession {
    private final AuthHandler authHandler;
    private String accessToken;
    private String refreshToken;
    private OkHttpClient okHttpClient;

    ShoeboxedSession(Builder builder) {
        this.authHandler = AuthHandler.forApplication(builder.apiApplication);
        this.accessToken = builder.accessToken;
        this.refreshToken = builder.refreshToken;
        this.okHttpClient = builder.okHttpClient;
    }

    ShoeboxedSession(AuthHandler authHandler, String accessToken, String refreshToken, OkHttpClient okHttpClient) {
        this.authHandler = authHandler;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.okHttpClient = okHttpClient;
    }

    String getAccessToken() throws IOException {
        if (this.accessToken == null) {
            this.refreshAccessToken();
        }
        if (this.accessToken == null) {
            throw new IOException("Access token is not available");
        }
        return this.accessToken;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    void refreshAccessToken() throws IOException {
        if (this.refreshToken == null) {
            throw new IOException("Refresh token is not available");
        }
        AuthHandler.Tokens tokens = this.authHandler.refreshTokens(this.refreshToken);
        this.accessToken = tokens.getAccessToken();
    }

    public static final class Builder {
        private String accessToken;
        private String refreshToken;
        private OkHttpClient okHttpClient;
        private final ApiApplication apiApplication;

        public Builder(ApiApplication apiApplication, OkHttpClient okHttpClient) {
            this.apiApplication = apiApplication;
            this.okHttpClient = okHttpClient;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public ShoeboxedSession build() {
            return new ShoeboxedSession(this);
        }
    }
}

