/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.shoeboxed;

import io.scanbot.shoeboxed.RestServiceProvider;
import io.scanbot.shoeboxed.ShoeboxedRestService;
import io.scanbot.shoeboxed.ShoeboxedSession;
import io.scanbot.shoeboxed.UnauthorizedException;
import io.scanbot.shoeboxed.entity.Account;
import io.scanbot.shoeboxed.entity.Category;
import io.scanbot.shoeboxed.entity.Document;
import io.scanbot.shoeboxed.entity.container.Accounts;
import io.scanbot.shoeboxed.entity.container.Categories;
import io.scanbot.shoeboxed.entity.request.CreateCategoryRequest;
import io.scanbot.shoeboxed.entity.request.CreateDocumentRequest;
import java.io.File;
import java.io.IOException;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class ShoeboxedApi {
    private static final String UPLOAD_FILE_PART = "attachment";
    private final ShoeboxedRestService restService;

    public static ShoeboxedApi forSession(ShoeboxedSession shoeboxedSession) {
        return new ShoeboxedApi(RestServiceProvider.forSession(shoeboxedSession).getService());
    }

    static ShoeboxedApi forServiceProvider(RestServiceProvider restServiceProvider) {
        return new ShoeboxedApi(restServiceProvider.getService());
    }

    ShoeboxedApi(ShoeboxedRestService restService) {
        this.restService = restService;
    }

    public List<Account> getAccounts() throws IOException {
        try {
            return ((Accounts)this.restService.getAccounts().execute().body()).list();
        }
        catch (UnauthorizedException e) {
            return ((Accounts)this.restService.getAccounts().execute().body()).list();
        }
    }

    public List<Category> getCategories(long accountId) throws IOException {
        try {
            return ((Categories)this.restService.getCategories(accountId).execute().body()).list();
        }
        catch (UnauthorizedException e) {
            return ((Categories)this.restService.getCategories(accountId).execute().body()).list();
        }
    }

    public Category createCategory(long accountId, CreateCategoryRequest request) throws IOException {
        try {
            return (Category)this.restService.createCategory(accountId, request).execute().body();
        }
        catch (UnauthorizedException e) {
            return (Category)this.restService.createCategory(accountId, request).execute().body();
        }
    }

    public Document createDocument(long accountId, String mime, File file, CreateDocumentRequest request) throws IOException {
        MultipartBody.Part filePart = ShoeboxedApi.getFilePart(mime, file);
        try {
            return (Document)this.restService.createDocument(accountId, filePart, request).execute().body();
        }
        catch (UnauthorizedException e) {
            return (Document)this.restService.createDocument(accountId, filePart, request).execute().body();
        }
    }

    private static MultipartBody.Part getFilePart(String mime, File file) {
        RequestBody filePart = RequestBody.create((File)file, (MediaType)MediaType.parse((String)mime));
        return MultipartBody.Part.createFormData((String)UPLOAD_FILE_PART, (String)file.getName(), (RequestBody)filePart);
    }

    private static RequestBody getTextPart(String text) {
        return RequestBody.create((String)text, (MediaType)MediaType.parse((String)"text/plain"));
    }

    public void deleteDocument(long accountId, String documentId) throws IOException {
        try {
            this.restService.deleteDocument(accountId, documentId).execute();
        }
        catch (UnauthorizedException e) {
            this.restService.deleteDocument(accountId, documentId).execute();
        }
    }
}

