/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.tesseract.android;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.Log;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.leptonica.android.Pixa;
import com.googlecode.leptonica.android.ReadFile;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessPdfRenderer;
import java.io.File;

public class TessBaseAPI {
    private long mNativeData;
    public static final String VAR_CHAR_WHITELIST = "tessedit_char_whitelist";
    public static final String VAR_CHAR_BLACKLIST = "tessedit_char_blacklist";
    public static final int OEM_TESSERACT_ONLY = 0;
    public static final int OEM_CUBE_ONLY = 1;
    public static final int OEM_TESSERACT_CUBE_COMBINED = 2;
    public static final int OEM_DEFAULT = 3;

    public TessBaseAPI() {
        this.nativeConstruct();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Log.d((String)"TessBaseAPI.java", (String)"finalize(): NOT calling nativeFinalize() due to premature garbage collection");
        }
        finally {
            Log.d((String)"TessBaseAPI.java", (String)"finalize(): calling super.finalize()");
            super.finalize();
        }
    }

    public boolean init(String datapath, String language) {
        File tessdata;
        if (datapath == null) {
            throw new IllegalArgumentException("Data path must not be null!");
        }
        if (!datapath.endsWith(File.separator)) {
            datapath = datapath + File.separator;
        }
        if (!(tessdata = new File(datapath + "tessdata")).exists() || !tessdata.isDirectory()) {
            throw new IllegalArgumentException("Data path must contain subfolder tessdata!");
        }
        return this.nativeInit(datapath, language);
    }

    public boolean init(String datapath, String language, int ocrEngineMode) {
        File tessdata;
        if (datapath == null) {
            throw new IllegalArgumentException("Data path must not be null!");
        }
        if (!datapath.endsWith(File.separator)) {
            datapath = datapath + File.separator;
        }
        if (!(tessdata = new File(datapath + "tessdata")).exists() || !tessdata.isDirectory()) {
            throw new IllegalArgumentException("Data path must contain subfolder tessdata!");
        }
        return this.nativeInitOem(datapath, language, ocrEngineMode);
    }

    public String getInitLanguagesAsString() {
        return this.nativeGetInitLanguagesAsString();
    }

    public void clear() {
        this.nativeClear();
    }

    public void end() {
        this.nativeEnd();
    }

    public boolean setVariable(String var, String value) {
        return this.nativeSetVariable(var, value);
    }

    public void setPageSegMode(int mode) {
        this.nativeSetPageSegMode(mode);
    }

    public void setDebug(boolean enabled) {
        this.nativeSetDebug(enabled);
    }

    public void setRectangle(Rect rect) {
        this.setRectangle(rect.left, rect.top, rect.width(), rect.height());
    }

    public void setRectangle(int left, int top, int width, int height) {
        this.nativeSetRectangle(left, top, width, height);
    }

    public void setImage(File file) {
        Pix image = ReadFile.readFile(file);
        if (image == null) {
            throw new RuntimeException("Failed to read image file");
        }
        this.nativeSetImagePix(image.getNativePix());
    }

    public void setImage(Bitmap bmp) {
        Pix image = ReadFile.readBitmap(bmp);
        if (image == null) {
            throw new RuntimeException("Failed to read bitmap");
        }
        this.nativeSetImagePix(image.getNativePix());
    }

    public void setImage(Pix image) {
        this.nativeSetImagePix(image.getNativePix());
    }

    public void setImage(byte[] imagedata, int width, int height, int bpp, int bpl) {
        this.nativeSetImageBytes(imagedata, width, height, bpp, bpl);
    }

    public String getUTF8Text() {
        String text = this.nativeGetUTF8Text();
        return text.trim();
    }

    public int meanConfidence() {
        return this.nativeMeanConfidence();
    }

    public int[] wordConfidences() {
        int[] conf = this.nativeWordConfidences();
        if (conf == null) {
            conf = new int[]{};
        }
        return conf;
    }

    public Pix getThresholdedImage() {
        return new Pix(this.nativeGetThresholdedImage());
    }

    public Pixa getRegions() {
        return new Pixa(this.nativeGetRegions(), 0, 0);
    }

    public Pixa getTextlines() {
        return new Pixa(this.nativeGetTextlines(), 0, 0);
    }

    public Pixa getStrips() {
        return new Pixa(this.nativeGetStrips(), 0, 0);
    }

    public Pixa getWords() {
        return new Pixa(this.nativeGetWords(), 0, 0);
    }

    public ResultIterator getResultIterator() {
        long nativeResultIterator = this.nativeGetResultIterator();
        if (nativeResultIterator == 0L) {
            return null;
        }
        return new ResultIterator(nativeResultIterator);
    }

    public String getHOCRText(int page) {
        return this.nativeGetHOCRText(page);
    }

    public void setInputName(String name) {
        this.nativeSetInputName(name);
    }

    public void setOutputName(String name) {
        this.nativeSetOutputName(name);
    }

    public void ReadConfigFile(String filename) {
        this.nativeReadConfigFile(filename);
    }

    public String getBoxText(int page) {
        return this.nativeGetBoxText(page);
    }

    public boolean beginDocument(TessPdfRenderer tessPdfRenderer) {
        return this.nativeBeginDocument(tessPdfRenderer.getNativePointer());
    }

    public boolean endDocument(TessPdfRenderer tessPdfRenderer) {
        return this.nativeEndDocument(tessPdfRenderer.getNativePointer());
    }

    public boolean addPageToDocument(Pix imageToProcess, String imageToWrite, TessPdfRenderer tessPdfRenderer) {
        return this.nativeAddPageToDocument(imageToProcess.getNativePix(), imageToWrite, tessPdfRenderer.getNativePointer());
    }

    private static native void nativeClassInit();

    private native void nativeConstruct();

    private native void nativeFinalize();

    private native boolean nativeInit(String var1, String var2);

    private native boolean nativeInitOem(String var1, String var2, int var3);

    private native String nativeGetInitLanguagesAsString();

    private native void nativeClear();

    private native void nativeEnd();

    private native void nativeSetImageBytes(byte[] var1, int var2, int var3, int var4, int var5);

    private native void nativeSetImagePix(long var1);

    private native void nativeSetRectangle(int var1, int var2, int var3, int var4);

    private native String nativeGetUTF8Text();

    private native int nativeMeanConfidence();

    private native int[] nativeWordConfidences();

    private native boolean nativeSetVariable(String var1, String var2);

    private native void nativeSetDebug(boolean var1);

    private native void nativeSetPageSegMode(int var1);

    private native long nativeGetThresholdedImage();

    private native long nativeGetRegions();

    private native long nativeGetTextlines();

    private native long nativeGetStrips();

    private native long nativeGetWords();

    private native long nativeGetResultIterator();

    private native String nativeGetBoxText(int var1);

    private native String nativeGetHOCRText(int var1);

    private native void nativeSetInputName(String var1);

    private native void nativeSetOutputName(String var1);

    private native void nativeReadConfigFile(String var1);

    private native boolean nativeBeginDocument(long var1);

    private native boolean nativeEndDocument(long var1);

    private native boolean nativeAddPageToDocument(long var1, String var3, long var4);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("tess");
        TessBaseAPI.nativeClassInit();
    }

    public static final class PageIteratorLevel {
        public static final int RIL_BLOCK = 0;
        public static final int RIL_PARA = 1;
        public static final int RIL_TEXTLINE = 2;
        public static final int RIL_WORD = 3;
        public static final int RIL_SYMBOL = 4;
    }

    public static final class PageSegMode {
        public static final int PSM_OSD_ONLY = 0;
        public static final int PSM_AUTO_OSD = 1;
        public static final int PSM_AUTO_ONLY = 2;
        public static final int PSM_AUTO = 3;
        public static final int PSM_SINGLE_COLUMN = 4;
        public static final int PSM_SINGLE_BLOCK_VERT_TEXT = 5;
        public static final int PSM_SINGLE_BLOCK = 6;
        public static final int PSM_SINGLE_LINE = 7;
        public static final int PSM_SINGLE_WORD = 8;
        public static final int PSM_CIRCLE_WORD = 9;
        public static final int PSM_SINGLE_CHAR = 10;
        public static final int PSM_SPARSE_TEXT = 11;
        public static final int PSM_SPARSE_TEXT_OSD = 12;
        public static final int PSM_COUNT = 13;
    }
}

