/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import com.googlecode.leptonica.android.Pix;

public class Scale {
    public static Pix scaleToSize(Pix pixs, int width, int height, ScaleType type) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        int pixWidth = pixs.getWidth();
        int pixHeight = pixs.getHeight();
        float scaleX = (float)width / (float)pixWidth;
        float scaleY = (float)height / (float)pixHeight;
        switch (type) {
            case FILL: {
                break;
            }
            case FIT: {
                scaleY = scaleX = Math.min(scaleX, scaleY);
                break;
            }
            case FIT_SHRINK: {
                scaleY = scaleX = Math.min(1.0f, Math.min(scaleX, scaleY));
            }
        }
        return Scale.scale(pixs, scaleX, scaleY);
    }

    public static Pix scale(Pix pixs, float scale) {
        return Scale.scale(pixs, scale, scale);
    }

    public static Pix scale(Pix pixs, float scaleX, float scaleY) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        if (scaleX <= 0.0f) {
            throw new IllegalArgumentException("X scaling factor must be positive");
        }
        if (scaleY <= 0.0f) {
            throw new IllegalArgumentException("Y scaling factor must be positive");
        }
        long nativePix = Scale.nativeScale(pixs.mNativePix, scaleX, scaleY);
        if (nativePix == 0L) {
            throw new RuntimeException("Failed to natively scale pix");
        }
        return new Pix(nativePix);
    }

    private static native long nativeScale(long var0, float var2, float var3);

    static {
        System.loadLibrary("lept");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScaleType {
        FILL,
        FIT,
        FIT_SHRINK;

    }
}

