/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Bitmap;
import com.googlecode.leptonica.android.Convert;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.leptonica.android.Pixa;
import java.io.File;

public class WriteFile {
    public static final int DEFAULT_QUALITY = 85;
    public static final boolean DEFAULT_PROGRESSIVE = true;

    public static byte[] writeBytes8(Pix pixs) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        int size = pixs.getWidth() * pixs.getHeight();
        if (pixs.getDepth() != 8) {
            Pix pix8 = Convert.convertTo8(pixs);
            pixs.recycle();
            pixs = pix8;
        }
        byte[] data = new byte[size];
        WriteFile.writeBytes8(pixs, data);
        return data;
    }

    public static int writeBytes8(Pix pixs, byte[] data) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        int size = pixs.getWidth() * pixs.getHeight();
        if (data.length < size) {
            throw new IllegalArgumentException("Data array must be large enough to hold image bytes");
        }
        int bytesWritten = WriteFile.nativeWriteBytes8(pixs.mNativePix, data);
        return bytesWritten;
    }

    public static boolean writeFiles(Pixa pixas, File path, String prefix, int format) {
        if (pixas == null) {
            throw new IllegalArgumentException("Source pixa must be non-null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Destination path non-null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Filename prefix must be non-null");
        }
        throw new RuntimeException("writeFiles() is not currently supported");
    }

    public static byte[] writeMem(Pix pixs, int format) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        throw new RuntimeException("writeMem() is not currently supported");
    }

    public static boolean writeImpliedFormat(Pix pixs, File file) {
        return WriteFile.writeImpliedFormat(pixs, file, 85, true);
    }

    public static boolean writeImpliedFormat(Pix pixs, File file, int quality, boolean progressive) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        if (file == null) {
            throw new IllegalArgumentException("File must be non-null");
        }
        return WriteFile.nativeWriteImpliedFormat(pixs.mNativePix, file.getAbsolutePath(), quality, progressive);
    }

    public static Bitmap writeBitmap(Pix pixs) {
        Bitmap.Config config;
        int height;
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        int[] dimensions = pixs.getDimensions();
        int width = dimensions[0];
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)(height = dimensions[1]), (Bitmap.Config)(config = Bitmap.Config.ARGB_8888));
        if (WriteFile.nativeWriteBitmap(pixs.mNativePix, bitmap)) {
            return bitmap;
        }
        bitmap.recycle();
        return null;
    }

    private static native int nativeWriteBytes8(long var0, byte[] var2);

    private static native boolean nativeWriteFiles(long var0, String var2, int var3);

    private static native byte[] nativeWriteMem(long var0, int var2);

    private static native boolean nativeWriteImpliedFormat(long var0, String var2, int var3, boolean var4);

    private static native boolean nativeWriteBitmap(long var0, Bitmap var2);

    static {
        System.loadLibrary("lept");
    }
}

