/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import com.googlecode.leptonica.android.Pix;

public class AdaptiveMap {
    private static final int NORM_REDUCTION = 16;
    private static final int NORM_SIZE = 3;
    private static final int NORM_BG_VALUE = 200;
    public static final int DEFAULT_TILE_WIDTH = 10;
    public static final int DEFAULT_TILE_HEIGHT = 15;
    public static final int DEFAULT_MIN_COUNT = 40;
    public static final int DEFAULT_X_SMOOTH_SIZE = 2;
    public static final int DEFAULT_Y_SMOOTH_SIZE = 1;

    public static Pix backgroundNormMorph(Pix pixs) {
        return AdaptiveMap.backgroundNormMorph(pixs, 16, 3, 200);
    }

    public static Pix backgroundNormMorph(Pix pixs, int normReduction, int normSize, int normBgValue) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        long nativePix = AdaptiveMap.nativeBackgroundNormMorph(pixs.getNativePix(), normReduction, normSize, normBgValue);
        if (nativePix == 0L) {
            throw new RuntimeException("Failed to normalize image background");
        }
        return new Pix(nativePix);
    }

    public static Pix pixContrastNorm(Pix pixs) {
        return AdaptiveMap.pixContrastNorm(pixs, 10, 15, 40, 2, 1);
    }

    public static Pix pixContrastNorm(Pix pixs, int sizeX, int sizeY, int minDiff, int smoothX, int smoothY) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        long nativePix = AdaptiveMap.nativePixContrastNorm(pixs.getNativePix(), sizeX, sizeY, minDiff, smoothX, smoothY);
        if (nativePix == 0L) {
            throw new RuntimeException("Failed to normalize image contrast");
        }
        return new Pix(nativePix);
    }

    private static native long nativeBackgroundNormMorph(long var0, int var2, int var3, int var4);

    private static native long nativePixContrastNorm(long var0, int var2, int var3, int var4, int var5, int var6);

    static {
        System.loadLibrary("jpgt");
        System.loadLibrary("pngt");
        System.loadLibrary("lept");
    }
}

