/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import com.googlecode.leptonica.android.Pix;

public class Enhance {
    public static final int DEFAULT_UNSHARP_HALFWIDTH = 1;
    public static final float DEFAULT_UNSHARP_FRACTION = 0.3f;

    public static Pix unsharpMasking(Pix pixs) {
        return Enhance.unsharpMasking(pixs, 1, 0.3f);
    }

    public static Pix unsharpMasking(Pix pixs, int halfwidth, float fraction) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        long nativePix = Enhance.nativeUnsharpMasking(pixs.getNativePix(), halfwidth, fraction);
        if (nativePix == 0L) {
            throw new OutOfMemoryError();
        }
        return new Pix(nativePix);
    }

    private static native long nativeUnsharpMasking(long var0, int var2, float var3);

    static {
        System.loadLibrary("jpgt");
        System.loadLibrary("pngt");
        System.loadLibrary("lept");
    }
}

