/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.tesseract.android;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.support.annotation.WorkerThread;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.leptonica.android.Pixa;
import com.googlecode.leptonica.android.ReadFile;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessPdfRenderer;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TessBaseAPI {
    private long mNativeData = this.nativeConstruct();
    public static final String VAR_CHAR_WHITELIST = "tessedit_char_whitelist";
    public static final String VAR_CHAR_BLACKLIST = "tessedit_char_blacklist";
    public static final String VAR_SAVE_BLOB_CHOICES = "save_blob_choices";
    public static final String VAR_TRUE = "T";
    public static final String VAR_FALSE = "F";
    public static final int OEM_TESSERACT_ONLY = 0;
    @Deprecated
    public static final int OEM_CUBE_ONLY = 1;
    @Deprecated
    public static final int OEM_TESSERACT_CUBE_COMBINED = 2;
    public static final int OEM_DEFAULT = 3;
    private ProgressNotifier progressNotifier;
    private boolean mRecycled;

    public TessBaseAPI() {
        if (this.mNativeData == 0L) {
            throw new RuntimeException("Can't create TessBaseApi object");
        }
        this.mRecycled = false;
    }

    public TessBaseAPI(ProgressNotifier progressNotifier) {
        this();
        this.progressNotifier = progressNotifier;
    }

    public boolean init(String datapath, String language) {
        return this.init(datapath, language, 3);
    }

    public boolean init(String datapath, String language, int ocrEngineMode) {
        boolean success;
        File datapathFile;
        if (datapath == null) {
            throw new IllegalArgumentException("Data path must not be null!");
        }
        if (!datapath.endsWith(File.separator)) {
            datapath = datapath + File.separator;
        }
        if (!(datapathFile = new File(datapath)).exists()) {
            throw new IllegalArgumentException("Data path does not exist!");
        }
        File tessdata = new File(datapath + "tessdata");
        if (!tessdata.exists() || !tessdata.isDirectory()) {
            throw new IllegalArgumentException("Data path must contain subfolder tessdata!");
        }
        if (ocrEngineMode != 1) {
            for (String languageCode : language.split("\\+")) {
                boolean sampleCubeFileExists;
                if (languageCode.startsWith("~")) continue;
                File datafile = new File(tessdata + File.separator + languageCode + ".traineddata");
                if (!datafile.exists()) {
                    throw new IllegalArgumentException("Data file not found at " + datafile);
                }
                if (!languageCode.equals("ara") && (!languageCode.equals("hin") || ocrEngineMode != 3) || (sampleCubeFileExists = new File(tessdata + File.separator + languageCode + ".cube.params").exists())) continue;
                throw new IllegalArgumentException("Cube data files not found. See https://github.com/rmtheis/tess-two/issues/239");
            }
        }
        if (success = this.nativeInitOem(this.mNativeData, datapath, language, ocrEngineMode)) {
            this.mRecycled = false;
        }
        return success;
    }

    public String getInitLanguagesAsString() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.nativeGetInitLanguagesAsString(this.mNativeData);
    }

    public void clear() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeClear(this.mNativeData);
    }

    public void end() {
        if (!this.mRecycled) {
            this.nativeEnd(this.mNativeData);
            this.mRecycled = true;
        }
    }

    public boolean setVariable(String var, String value) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.nativeSetVariable(this.mNativeData, var, value);
    }

    public int getPageSegMode() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.nativeGetPageSegMode(this.mNativeData);
    }

    public void setPageSegMode(int mode) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeSetPageSegMode(this.mNativeData, mode);
    }

    public void setDebug(boolean enabled) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeSetDebug(this.mNativeData, enabled);
    }

    public void setRectangle(Rect rect) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.setRectangle(rect.left, rect.top, rect.width(), rect.height());
    }

    public void setRectangle(int left, int top, int width, int height) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeSetRectangle(this.mNativeData, left, top, width, height);
    }

    @WorkerThread
    public void setImage(File file) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        Pix image = ReadFile.readFile(file);
        if (image == null) {
            throw new RuntimeException("Failed to read image file");
        }
        this.nativeSetImagePix(this.mNativeData, image.getNativePix());
        image.recycle();
    }

    @WorkerThread
    public void setImage(Bitmap bmp) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        Pix image = ReadFile.readBitmap(bmp);
        if (image == null) {
            throw new RuntimeException("Failed to read bitmap");
        }
        this.nativeSetImagePix(this.mNativeData, image.getNativePix());
        image.recycle();
    }

    @WorkerThread
    public void setImage(Pix image) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeSetImagePix(this.mNativeData, image.getNativePix());
    }

    @WorkerThread
    public void setImage(byte[] imagedata, int width, int height, int bpp, int bpl) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeSetImageBytes(this.mNativeData, imagedata, width, height, bpp, bpl);
    }

    @WorkerThread
    public String getUTF8Text() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        String text = this.nativeGetUTF8Text(this.mNativeData);
        return text != null ? text.trim() : null;
    }

    public int meanConfidence() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.nativeMeanConfidence(this.mNativeData);
    }

    public int[] wordConfidences() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        int[] conf = this.nativeWordConfidences(this.mNativeData);
        if (conf == null) {
            conf = new int[]{};
        }
        return conf;
    }

    public Pix getThresholdedImage() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return new Pix(this.nativeGetThresholdedImage(this.mNativeData));
    }

    public Pixa getRegions() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return new Pixa(this.nativeGetRegions(this.mNativeData), 0, 0);
    }

    public Pixa getTextlines() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return new Pixa(this.nativeGetTextlines(this.mNativeData), 0, 0);
    }

    public Pixa getStrips() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return new Pixa(this.nativeGetStrips(this.mNativeData), 0, 0);
    }

    public Pixa getWords() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return new Pixa(this.nativeGetWords(this.mNativeData), 0, 0);
    }

    public Pixa getConnectedComponents() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return new Pixa(this.nativeGetConnectedComponents(this.mNativeData), 0, 0);
    }

    public ResultIterator getResultIterator() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        long nativeResultIterator = this.nativeGetResultIterator(this.mNativeData);
        if (nativeResultIterator == 0L) {
            return null;
        }
        return new ResultIterator(nativeResultIterator);
    }

    @WorkerThread
    public String getHOCRText(int page) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.nativeGetHOCRText(this.mNativeData, page);
    }

    public void setInputName(String name) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeSetInputName(this.mNativeData, name);
    }

    public void setOutputName(String name) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeSetOutputName(this.mNativeData, name);
    }

    public void readConfigFile(String filename) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeReadConfigFile(this.mNativeData, filename);
    }

    public String getBoxText(int page) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.nativeGetBoxText(this.mNativeData, page);
    }

    public String getVersion() {
        return this.nativeGetVersion(this.mNativeData);
    }

    public void stop() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeStop(this.mNativeData);
    }

    protected void onProgressValues(int percent, int left, int right, int top, int bottom, int textLeft, int textRight, int textTop, int textBottom) {
        if (this.progressNotifier != null) {
            Rect wordRect = new Rect(left, textTop - top, right, textTop - bottom);
            Rect textRect = new Rect(textLeft, textBottom, textRight, textTop);
            ProgressValues pv = new ProgressValues(percent, wordRect, textRect);
            this.progressNotifier.onProgressValues(pv);
        }
    }

    public boolean beginDocument(TessPdfRenderer tessPdfRenderer, String title) {
        return this.nativeBeginDocument(tessPdfRenderer.getNativePdfRenderer(), title);
    }

    public boolean beginDocument(TessPdfRenderer tessPdfRenderer) {
        return this.nativeBeginDocument(tessPdfRenderer.getNativePdfRenderer(), "");
    }

    public boolean endDocument(TessPdfRenderer tessPdfRenderer) {
        return this.nativeEndDocument(tessPdfRenderer.getNativePdfRenderer());
    }

    public boolean addPageToDocument(Pix imageToProcess, String imageToWrite, TessPdfRenderer tessPdfRenderer) {
        return this.nativeAddPageToDocument(this.mNativeData, imageToProcess.getNativePix(), imageToWrite, tessPdfRenderer.getNativePdfRenderer());
    }

    long getNativeData() {
        return this.mNativeData;
    }

    private static native void nativeClassInit();

    private native long nativeConstruct();

    private native void nativeEnd(long var1);

    private native boolean nativeInit(long var1, String var3, String var4);

    private native boolean nativeInitOem(long var1, String var3, String var4, int var5);

    private native String nativeGetInitLanguagesAsString(long var1);

    private native void nativeClear(long var1);

    private native void nativeSetImageBytes(long var1, byte[] var3, int var4, int var5, int var6, int var7);

    private native void nativeSetImagePix(long var1, long var3);

    private native void nativeSetRectangle(long var1, int var3, int var4, int var5, int var6);

    private native String nativeGetUTF8Text(long var1);

    private native int nativeMeanConfidence(long var1);

    private native int[] nativeWordConfidences(long var1);

    private native boolean nativeSetVariable(long var1, String var3, String var4);

    private native void nativeSetDebug(long var1, boolean var3);

    private native int nativeGetPageSegMode(long var1);

    private native void nativeSetPageSegMode(long var1, int var3);

    private native long nativeGetThresholdedImage(long var1);

    private native long nativeGetRegions(long var1);

    private native long nativeGetTextlines(long var1);

    private native long nativeGetStrips(long var1);

    private native long nativeGetWords(long var1);

    private native long nativeGetConnectedComponents(long var1);

    private native long nativeGetResultIterator(long var1);

    private native String nativeGetBoxText(long var1, int var3);

    private native String nativeGetHOCRText(long var1, int var3);

    private native void nativeSetInputName(long var1, String var3);

    private native void nativeSetOutputName(long var1, String var3);

    private native void nativeReadConfigFile(long var1, String var3);

    private native String nativeGetVersion(long var1);

    private native void nativeStop(long var1);

    private native boolean nativeBeginDocument(long var1, String var3);

    private native boolean nativeEndDocument(long var1);

    private native boolean nativeAddPageToDocument(long var1, long var3, String var5, long var6);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("tess");
        TessBaseAPI.nativeClassInit();
    }

    public class ProgressValues {
        private final int percent;
        private final Rect wordRect;
        private final Rect textRect;

        public ProgressValues(int percent, Rect wordRect, Rect textRect) {
            this.percent = percent;
            this.wordRect = wordRect;
            this.textRect = textRect;
        }

        public int getPercent() {
            return this.percent;
        }

        public Rect getCurrentWordRect() {
            return this.wordRect;
        }

        public Rect getCurrentRect() {
            return this.textRect;
        }
    }

    public static interface ProgressNotifier {
        public void onProgressValues(ProgressValues var1);
    }

    public static final class PageIteratorLevel {
        public static final int RIL_BLOCK = 0;
        public static final int RIL_PARA = 1;
        public static final int RIL_TEXTLINE = 2;
        public static final int RIL_WORD = 3;
        public static final int RIL_SYMBOL = 4;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Level {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OcrEngineMode {
    }

    public static final class PageSegMode {
        public static final int PSM_OSD_ONLY = 0;
        public static final int PSM_AUTO_OSD = 1;
        public static final int PSM_AUTO_ONLY = 2;
        public static final int PSM_AUTO = 3;
        public static final int PSM_SINGLE_COLUMN = 4;
        public static final int PSM_SINGLE_BLOCK_VERT_TEXT = 5;
        public static final int PSM_SINGLE_BLOCK = 6;
        public static final int PSM_SINGLE_LINE = 7;
        public static final int PSM_SINGLE_WORD = 8;
        public static final int PSM_CIRCLE_WORD = 9;
        public static final int PSM_SINGLE_CHAR = 10;
        public static final int PSM_SPARSE_TEXT = 11;
        public static final int PSM_SPARSE_TEXT_OSD = 12;
        public static final int PSM_RAW_LINE = 13;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Mode {
        }
    }
}

