/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.googlecode.leptonica.android.Pix;
import java.io.File;

public class ReadFile {
    private static final String LOG_TAG;

    public static Pix readMem(byte[] encodedData) {
        if (encodedData == null) {
            Log.e((String)LOG_TAG, (String)"Image data byte array must be non-null");
            return null;
        }
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inPreferredConfig = Bitmap.Config.ARGB_8888;
        Bitmap bmp = BitmapFactory.decodeByteArray((byte[])encodedData, (int)0, (int)encodedData.length, (BitmapFactory.Options)opts);
        Pix pix = ReadFile.readBitmap(bmp);
        bmp.recycle();
        return pix;
    }

    public static Pix readBytes8(byte[] pixelData, int width, int height) {
        if (pixelData == null) {
            throw new IllegalArgumentException("Byte array must be non-null");
        }
        if (width <= 0) {
            throw new IllegalArgumentException("Image width must be greater than 0");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Image height must be greater than 0");
        }
        if (pixelData.length < width * height) {
            throw new IllegalArgumentException("Array length does not match dimensions");
        }
        long nativePix = ReadFile.nativeReadBytes8(pixelData, width, height);
        if (nativePix == 0L) {
            throw new RuntimeException("Failed to read pix from memory");
        }
        return new Pix(nativePix);
    }

    public static boolean replaceBytes8(Pix pixs, byte[] pixelData, int width, int height) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        if (pixelData == null) {
            throw new IllegalArgumentException("Byte array must be non-null");
        }
        if (width <= 0) {
            throw new IllegalArgumentException("Image width must be greater than 0");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Image height must be greater than 0");
        }
        if (pixelData.length < width * height) {
            throw new IllegalArgumentException("Array length does not match dimensions");
        }
        if (pixs.getWidth() != width) {
            throw new IllegalArgumentException("Source pix width does not match image width");
        }
        if (pixs.getHeight() != height) {
            throw new IllegalArgumentException("Source pix height does not match image height");
        }
        return ReadFile.nativeReplaceBytes8(pixs.getNativePix(), pixelData, width, height);
    }

    public static Pix readFile(File file) {
        if (file == null) {
            Log.e((String)LOG_TAG, (String)"File must be non-null");
            return null;
        }
        if (!file.exists()) {
            Log.e((String)LOG_TAG, (String)"File does not exist");
            return null;
        }
        if (!file.canRead()) {
            Log.e((String)LOG_TAG, (String)"Cannot read file");
            return null;
        }
        long nativePix = ReadFile.nativeReadFile(file.getAbsolutePath());
        if (nativePix != 0L) {
            return new Pix(nativePix);
        }
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inPreferredConfig = Bitmap.Config.ARGB_8888;
        Bitmap bmp = BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)opts);
        if (bmp == null) {
            Log.e((String)LOG_TAG, (String)"Cannot decode bitmap");
            return null;
        }
        Pix pix = ReadFile.readBitmap(bmp);
        bmp.recycle();
        return pix;
    }

    public static Pix readBitmap(Bitmap bmp) {
        if (bmp == null) {
            Log.e((String)LOG_TAG, (String)"Bitmap must be non-null");
            return null;
        }
        if (bmp.getConfig() != Bitmap.Config.ARGB_8888) {
            Log.e((String)LOG_TAG, (String)"Bitmap config must be ARGB_8888");
            return null;
        }
        long nativePix = ReadFile.nativeReadBitmap(bmp);
        if (nativePix == 0L) {
            Log.e((String)LOG_TAG, (String)"Failed to read pix from bitmap");
            return null;
        }
        return new Pix(nativePix);
    }

    private static native long nativeReadMem(byte[] var0, int var1);

    private static native long nativeReadBytes8(byte[] var0, int var1, int var2);

    private static native boolean nativeReplaceBytes8(long var0, byte[] var2, int var3, int var4);

    private static native long nativeReadFile(String var0);

    private static native long nativeReadBitmap(Bitmap var0);

    static {
        System.loadLibrary("lept");
        LOG_TAG = ReadFile.class.getSimpleName();
    }
}

