/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.tools.utils;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0086\b\u00f8\u0001\u0000\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0006\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u000f*\u00020\u000f\"\u0019\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0011"}, d2={"logTag", "", "Lkotlin/reflect/KClass;", "getLogTag", "(Lkotlin/reflect/KClass;)Ljava/lang/String;", "currentSyncTimeMillis", "", "measureMillisTime", "block", "Lkotlin/Function0;", "", "millisToHumanReadable", "millis", "isEven", "", "", "reduceToEven", "utils_release"})
public final class KotlinExtensionsKt {
    @NotNull
    public static final String getLogTag(@NotNull KClass<?> $this$logTag) {
        Intrinsics.checkNotNullParameter($this$logTag, (String)"<this>");
        String string = JvmClassMappingKt.getJavaClass($this$logTag).getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return StringsKt.take((String)string, (int)23);
    }

    public static final boolean isEven(int $this$isEven) {
        return $this$isEven % 2 == 0;
    }

    public static final int reduceToEven(int $this$reduceToEven) {
        return KotlinExtensionsKt.isEven($this$reduceToEven) ? $this$reduceToEven : $this$reduceToEven - 1;
    }

    public static final long currentSyncTimeMillis() {
        return (long)((float)System.nanoTime() / (float)1000000);
    }

    public static final long measureMillisTime(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$measureMillisTime = false;
        long start = KotlinExtensionsKt.currentSyncTimeMillis();
        block.invoke();
        return KotlinExtensionsKt.currentSyncTimeMillis() - start;
    }

    @NotNull
    public static final String millisToHumanReadable(long millis) {
        if (millis == 0L) {
            return "0s";
        }
        long millisLeft = millis % (long)1000;
        long secondsTotal = millis / (long)1000;
        long minutesTotal = secondsTotal / (long)60;
        long hours = minutesTotal / (long)60;
        long minutesOfHour = minutesTotal % (long)60;
        List strParts = new ArrayList();
        if (hours != 0L) {
            strParts.add("" + hours + 'h');
        }
        if (minutesOfHour != 0L || hours != 0L) {
            strParts.add("" + minutesOfHour + 'm');
        }
        if (secondsTotal % (long)60 != 0L || minutesOfHour != 0L || hours != 0L) {
            strParts.add("" + secondsTotal % (long)60 + 's');
        }
        if (millisLeft != 0L) {
            strParts.add(millisLeft + "ms");
        }
        return CollectionsKt.joinToString$default((Iterable)strParts, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }
}

