/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.w2scanner;

import io.scanbot.w2scanner.W2DetectorWrapper;
import io.scanbot.w2scanner.W2Parameters;
import io.scanbot.w2scanner.W2RecognizerWrapper;
import io.scanbot.w2scanner.YearRecognizerWrapper;
import java.io.File;
import java.io.Serializable;

public class TaxSDK {
    private final Parameters parameters;

    public TaxSDK(Parameters parameters) {
        this.parameters = parameters;
    }

    public W2DetectorWrapper w2Detector() {
        return W2DetectorWrapper.create(this.parameters.w2CascadePath);
    }

    public W2RecognizerWrapper w2Recognizer() {
        this.ensureCascadePathIsValid();
        return W2RecognizerWrapper.create(this.buildW2Parameters());
    }

    public YearRecognizerWrapper w2YearRecognizer() {
        this.ensureW2ParametersAreValid();
        return YearRecognizerWrapper.create(this.buildW2Parameters());
    }

    private void ensureCascadePathIsValid() {
        this.ensureFileExistsAndReadable("W2 cascade", this.parameters.w2CascadePath);
    }

    private void ensureW2ParametersAreValid() {
        this.ensureFileExistsAndReadable("W2 Label Detector", this.parameters.labelTrainedDataPath);
        this.ensureFileExistsAndReadable("Tesseract", this.parameters.tesseractTrainedDataPath);
    }

    private void ensureFileExistsAndReadable(String moduleName, String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path to " + moduleName + " is null. Did you forgot to specify it?");
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IllegalArgumentException(moduleName + " file does not exist: " + file);
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(moduleName + " file exist, but not readable: " + file);
        }
    }

    private W2Parameters buildW2Parameters() {
        return new W2Parameters(this.parameters.labelTrainedDataPath, this.parameters.tesseractTrainedDataPath);
    }

    static {
        System.loadLibrary("w2android");
    }

    public static class Parameters
    implements Serializable {
        final String labelTrainedDataPath;
        final String tesseractTrainedDataPath;
        final String w2CascadePath;

        private Parameters(Builder builder) {
            this.labelTrainedDataPath = builder.labelTrainedDataPath;
            this.tesseractTrainedDataPath = builder.tesseractTrainedDataPath;
            this.w2CascadePath = builder.w2CascadePath;
        }

        public String toString() {
            return "Parameters{labelTrainedDataPath='" + this.labelTrainedDataPath + '\'' + ", tesseractTrainedDataPath='" + this.tesseractTrainedDataPath + '\'' + ", w2CascadePath='" + this.w2CascadePath + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameters that = (Parameters)o;
            if (this.labelTrainedDataPath != null ? !this.labelTrainedDataPath.equals(that.labelTrainedDataPath) : that.labelTrainedDataPath != null) {
                return false;
            }
            if (this.tesseractTrainedDataPath != null ? !this.tesseractTrainedDataPath.equals(that.tesseractTrainedDataPath) : that.tesseractTrainedDataPath != null) {
                return false;
            }
            return this.w2CascadePath != null ? this.w2CascadePath.equals(that.w2CascadePath) : that.w2CascadePath == null;
        }

        public int hashCode() {
            int result = this.labelTrainedDataPath != null ? this.labelTrainedDataPath.hashCode() : 0;
            result = 31 * result + (this.tesseractTrainedDataPath != null ? this.tesseractTrainedDataPath.hashCode() : 0);
            result = 31 * result + (this.w2CascadePath != null ? this.w2CascadePath.hashCode() : 0);
            return result;
        }

        public static final class Builder {
            private String labelTrainedDataPath;
            private String tesseractTrainedDataPath;
            private String w2CascadePath;

            public Builder() {
            }

            public Builder(Parameters copy) {
                this.labelTrainedDataPath = copy.labelTrainedDataPath;
                this.tesseractTrainedDataPath = copy.tesseractTrainedDataPath;
                this.w2CascadePath = copy.w2CascadePath;
            }

            public Builder labelTrainedDataPath(String val) {
                this.labelTrainedDataPath = val;
                return this;
            }

            public Builder tesseractTrainedDataPath(String val) {
                this.tesseractTrainedDataPath = val;
                return this;
            }

            public Builder w2CascadePath(String val) {
                this.w2CascadePath = val;
                return this;
            }

            public Parameters build() {
                return new Parameters(this);
            }
        }
    }
}

