/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.w2scanner;

import io.scanbot.w2scanner.W2DetectionResult;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class W2DetectorWrapper {
    public abstract W2DetectionResult detectForms(byte[] var1, int var2, int var3, int var4);

    public static native W2DetectorWrapper create(String var0);

    private static final class CppProxy
    extends W2DetectorWrapper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public W2DetectionResult detectForms(byte[] nv21Image, int imageWidth, int imageHeight, int rotationDegrees) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_detectForms(this.nativeRef, nv21Image, imageWidth, imageHeight, rotationDegrees);
        }

        private native W2DetectionResult native_detectForms(long var1, byte[] var3, int var4, int var5, int var6);
    }
}

