/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.w2scanner;

import io.scanbot.w2scanner.W2Parameters;
import io.scanbot.w2scanner.W2YearRecognitionResult;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class YearRecognizerWrapper {
    public abstract W2YearRecognitionResult recognizeYear(byte[] var1, int var2);

    public static native YearRecognizerWrapper create(W2Parameters var0);

    private static final class CppProxy
    extends YearRecognizerWrapper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public W2YearRecognitionResult recognizeYear(byte[] image, int rotationDegrees) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_recognizeYear(this.nativeRef, image, rotationDegrees);
        }

        private native W2YearRecognitionResult native_recognizeYear(long var1, byte[] var3, int var4);
    }
}

