/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.w2scanner;

import io.scanbot.w2scanner.W2Field;
import io.scanbot.w2scanner.W2Parameters;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class W2RecognizerWrapper {
    public abstract ArrayList<W2Field> recognizeFields(byte[] var1, int var2);

    public static native W2RecognizerWrapper create(W2Parameters var0);

    private static final class CppProxy
    extends W2RecognizerWrapper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public ArrayList<W2Field> recognizeFields(byte[] image, int rotationDegrees) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_recognizeFields(this.nativeRef, image, rotationDegrees);
        }

        private native ArrayList<W2Field> native_recognizeFields(long var1, byte[] var3, int var4);
    }
}

