/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.w2scanner.view;

import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import io.scanbot.w2scanner.R;
import io.scanbot.w2scanner.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class MarkersOverlayView
extends View {
    private Drawable markerDrawable = null;
    private final List<ImmutablePoint> markers = new ArrayList<ImmutablePoint>();
    private final MarkersEvaluator evaluator = new MarkersEvaluator();
    private ValueAnimator markersAnimator;

    public MarkersOverlayView(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarkersOverlayView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (attrs == null) {
            return;
        }
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.MarkersOverlayView);
        try {
            this.markerDrawable = attributes.getDrawable(R.styleable.MarkersOverlayView_markerDrawable);
        }
        finally {
            attributes.recycle();
        }
    }

    public void setMarkerDrawable(Drawable markerDrawable) {
        this.markerDrawable = markerDrawable;
        this.invalidate();
    }

    public final void setMarkerRectangles(List<Rectangle> markers) {
        if (this.markersAnimator != null) {
            this.markersAnimator.cancel();
            this.markersAnimator = null;
        }
        this.markersAnimator = ValueAnimator.ofObject((TypeEvaluator)this.evaluator, (Object[])new Object[]{this.markers, ImmutablePoint.fromRectanges(markers)});
        this.markersAnimator.start();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.markerDrawable == null) {
            return;
        }
        for (ImmutablePoint marker : this.markers) {
            int centerX = (int)((float)this.getWidth() * marker.x);
            int centerY = (int)((float)this.getHeight() * marker.y);
            this.markerDrawable.setBounds(centerX - this.markerDrawable.getIntrinsicWidth(), centerY - this.markerDrawable.getIntrinsicHeight(), centerX + this.markerDrawable.getIntrinsicWidth(), centerY + this.markerDrawable.getIntrinsicHeight());
            this.markerDrawable.draw(canvas);
        }
    }

    private static final class ImmutablePoint {
        public final float x;
        public final float y;

        static List<ImmutablePoint> fromRectanges(List<Rectangle> rectangles) {
            ArrayList<ImmutablePoint> output = new ArrayList<ImmutablePoint>();
            for (Rectangle rectangle : rectangles) {
                output.add(new ImmutablePoint(rectangle.getX() + rectangle.getWidth() / 2.0f, rectangle.getY() + rectangle.getHeight() / 2.0f));
            }
            return output;
        }

        ImmutablePoint(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }

    private class MarkersEvaluator
    implements TypeEvaluator<List<ImmutablePoint>> {
        private MarkersEvaluator() {
        }

        public List<ImmutablePoint> evaluate(float fraction, List<ImmutablePoint> start, List<ImmutablePoint> end) {
            ArrayList<ImmutablePoint> newState = new ArrayList<ImmutablePoint>();
            for (int i = 0; i < end.size(); ++i) {
                ImmutablePoint endPoint = end.get(i);
                if (start.size() > i) {
                    ImmutablePoint startPoint = start.get(i);
                    newState.add(new ImmutablePoint(startPoint.x + (endPoint.x - startPoint.x) * fraction, startPoint.y + (endPoint.y - startPoint.y) * fraction));
                    continue;
                }
                newState.add(new ImmutablePoint(endPoint.x, endPoint.y));
            }
            MarkersOverlayView.this.markers.clear();
            MarkersOverlayView.this.markers.addAll(newState);
            MarkersOverlayView.this.invalidate();
            return null;
        }
    }
}

