/*
 * Decompiled with CFR 0.152.
 */
package net.doo.databaseinitializer;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import net.doo.databaseinitializer.AggregatesConnector;
import net.doo.databaseinitializer.ConnectTo;
import net.doo.databaseinitializer.DefaultGraph;
import net.doo.databaseinitializer.DefaultValues;
import net.doo.databaseinitializer.TestValue;
import net.doo.databaseinitializer.TestValueGenerator;

public class DatabaseInitializer {
    private SQLiteDatabase database;
    private Class<?> testValues;
    private Class<?> defaultValues;
    private Map<Aggregate, ContentValues> aggregateToValues = new LinkedHashMap<Aggregate, ContentValues>();

    public void initDatabase(SQLiteDatabase database, Class<?> testValues, Class<?> defaultValues) {
        this.database = database;
        if (testValues == null) {
            throw new NullPointerException("Test values are null");
        }
        if (defaultValues == null) {
            throw new NullPointerException("Default values are null");
        }
        this.testValues = testValues;
        this.defaultValues = defaultValues;
        try {
            this.prepareAggregates();
            this.applyDefaultsAndInsert();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void prepareAggregates() throws Exception {
        for (Field field : this.testValues.getDeclaredFields()) {
            this.processField(field);
        }
        for (AccessibleObject accessibleObject : this.testValues.getDeclaredMethods()) {
            this.processMethod((Method)accessibleObject);
        }
    }

    private void processField(Field field) throws Exception {
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            if (annotation instanceof TestValue) {
                this.processTestValue((TestValue)annotation, field);
                continue;
            }
            if (!(annotation instanceof ConnectTo)) continue;
            this.processConnectTo((ConnectTo)annotation, field);
        }
    }

    private void processMethod(Method method) throws Exception {
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            if (!(annotation instanceof TestValueGenerator)) continue;
            this.processTestValueGenerator((TestValueGenerator)annotation, method);
        }
    }

    private void processTestValue(TestValue annotation, Field field) throws Exception {
        field.setAccessible(true);
        Object fieldValue = field.get(this.testValues);
        ContentValues values = this.extractValues(annotation);
        String table = annotation.table();
        this.insert(fieldValue, table, values);
    }

    private void processTestValueGenerator(TestValueGenerator annotation, Method method) throws Exception {
        ContentValues values = new ContentValues();
        method.setAccessible(true);
        Object data = method.invoke(this.testValues, values);
        this.insert(data, annotation.value(), values);
    }

    private void insert(Object data, String table, ContentValues values) {
        if (data instanceof Iterable) {
            this.insertIterable((Iterable)data, table, values);
        } else if (data instanceof String[]) {
            this.insertArray((String[])data, table, values);
        } else {
            this.insertAggregate((String)data, table, values);
        }
    }

    private void insertIterable(Iterable<String> aggregateIds, String table, ContentValues values) {
        for (String id : aggregateIds) {
            ContentValues copy = new ContentValues();
            copy.putAll(values);
            this.insertAggregate(id, table, copy);
        }
    }

    private void insertArray(String[] aggregateIds, String table, ContentValues values) {
        for (String id : aggregateIds) {
            ContentValues copy = new ContentValues();
            copy.putAll(values);
            this.insertAggregate(id, table, copy);
        }
    }

    private void insertAggregate(String id, String table, ContentValues values) {
        Aggregate aggregate = new Aggregate(id, table);
        if (this.aggregateToValues.containsKey(aggregate)) {
            ContentValues total = this.aggregateToValues.get(aggregate);
            total.putAll(values);
            values = total;
        }
        this.aggregateToValues.put(aggregate, values);
    }

    private ContentValues extractValues(TestValue annotation) {
        ContentValues values = new ContentValues();
        if (!TextUtils.isEmpty((CharSequence)annotation.field())) {
            values.put(annotation.field(), annotation.value());
        }
        return values;
    }

    private void applyDefaultsAndInsert() {
        for (Aggregate aggregate : this.aggregateToValues.keySet()) {
            String id = aggregate.id;
            String table = aggregate.table;
            ContentValues defaults = this.getDefaultValuesForAggregate(id, table);
            ContentValues values = this.aggregateToValues.get(aggregate);
            defaults.putAll(values);
            values = defaults;
            this.insertToDatabase(table, values);
        }
    }

    private void processConnectTo(ConnectTo annotation, Field field) throws Exception {
        field.setAccessible(true);
        Object fieldValue = field.get(this.testValues);
        if (fieldValue instanceof Iterable) {
            this.connectIterable(annotation, (Iterable)fieldValue);
        } else if (fieldValue instanceof String[]) {
            this.connectArray(annotation, (String[])fieldValue);
        } else {
            this.connectAggregate(annotation, (String)fieldValue);
        }
    }

    private void connectArray(ConnectTo annotation, String[] ids) throws Exception {
        for (String id : ids) {
            this.connectAggregate(annotation, id);
        }
    }

    private void connectIterable(ConnectTo annotation, Iterable<String> ids) throws Exception {
        for (String id : ids) {
            this.connectAggregate(annotation, id);
        }
    }

    private void connectAggregate(ConnectTo annotation, String id) throws Exception {
        String graph = TextUtils.isEmpty((CharSequence)annotation.graph()) ? this.getDefaultGraphTable() : annotation.graph();
        Method connector = this.getAggregateConnectorForGraph(annotation.graph());
        ContentValues values = (ContentValues)connector.invoke(this.defaultValues, id, annotation.value());
        this.insertToDatabase(graph, values);
    }

    void insertToDatabase(String table, ContentValues values) {
        this.database.insert(table, null, values);
    }

    private ContentValues getDefaultValuesForAggregate(String id, String table) {
        try {
            for (Method method : this.defaultValues.getDeclaredMethods()) {
                DefaultValues annotation = method.getAnnotation(DefaultValues.class);
                if (annotation == null || !annotation.value().equals(table)) continue;
                method.setAccessible(true);
                return (ContentValues)method.invoke(this.defaultValues, id);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("DefaultValues for " + table + " were not found");
    }

    private String getDefaultGraphTable() {
        try {
            for (Field field : this.defaultValues.getDeclaredFields()) {
                DefaultGraph annotation = field.getAnnotation(DefaultGraph.class);
                if (annotation == null) continue;
                field.setAccessible(true);
                return (String)field.get(this.defaultValues);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("Default graph were not found");
    }

    private Method getAggregateConnectorForGraph(String graph) {
        try {
            for (Method method : this.defaultValues.getDeclaredMethods()) {
                AggregatesConnector annotation = method.getAnnotation(AggregatesConnector.class);
                if (annotation == null || !annotation.value().equals(graph)) continue;
                return method;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("Aggregate connector were not found");
    }

    static class Aggregate {
        String id;
        String table;

        Aggregate(String id, String table) {
            this.id = id;
            this.table = table;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Aggregate)) {
                return false;
            }
            Aggregate aggregate = (Aggregate)o;
            if (!this.id.equals(aggregate.id)) {
                return false;
            }
            return this.table.equals(aggregate.table);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.table.hashCode();
            return result;
        }
    }
}

