/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.Nullable;

final class SortedLists {
    private SortedLists() {
    }

    public static <E> int binarySearch(List<? extends E> list, @Nullable E key, Comparator<? super E> comparator, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(list);
        Preconditions.checkNotNull(presentBehavior);
        Preconditions.checkNotNull(absentBehavior);
        if (!(list instanceof RandomAccess)) {
            list = Lists.newArrayList(list);
        }
        int lower = 0;
        int upper = list.size() - 1;
        while (lower <= upper) {
            int middle = lower + upper >>> 1;
            int c = comparator.compare(key, list.get(middle));
            if (c < 0) {
                upper = middle - 1;
                continue;
            }
            if (c > 0) {
                lower = middle + 1;
                continue;
            }
            return lower + presentBehavior.resultIndex(comparator, key, list.subList(lower, upper + 1), middle - lower);
        }
        return absentBehavior.resultIndex(lower);
    }

    public static abstract class KeyAbsentBehavior
    extends Enum<KeyAbsentBehavior> {
        public static final /* enum */ KeyAbsentBehavior NEXT_LOWER = new KeyAbsentBehavior(){

            @Override
            int resultIndex(int higherIndex) {
                return higherIndex - 1;
            }
        };
        public static final /* enum */ KeyAbsentBehavior NEXT_HIGHER = new KeyAbsentBehavior(){

            @Override
            public int resultIndex(int higherIndex) {
                return higherIndex;
            }
        };
        public static final /* enum */ KeyAbsentBehavior INVERTED_INSERTION_INDEX = new KeyAbsentBehavior(){

            @Override
            public int resultIndex(int higherIndex) {
                return ~higherIndex;
            }
        };
        private static final /* synthetic */ KeyAbsentBehavior[] $VALUES;

        abstract int resultIndex(int var1);

        static {
            $VALUES = new KeyAbsentBehavior[]{NEXT_LOWER, NEXT_HIGHER, INVERTED_INSERTION_INDEX};
        }
    }

    public static abstract class KeyPresentBehavior
    extends Enum<KeyPresentBehavior> {
        public static final /* enum */ KeyPresentBehavior ANY_PRESENT = new KeyPresentBehavior(){

            @Override
            <E> int resultIndex(Comparator<? super E> comparator, E key, List<? extends E> list, int foundIndex) {
                return foundIndex;
            }
        };
        public static final /* enum */ KeyPresentBehavior LAST_PRESENT = new KeyPresentBehavior(){

            @Override
            <E> int resultIndex(Comparator<? super E> comparator, E key, List<? extends E> list, int foundIndex) {
                int lower = foundIndex;
                int upper = list.size() - 1;
                while (lower < upper) {
                    int middle = lower + upper + 1 >>> 1;
                    int c = comparator.compare(list.get(middle), key);
                    if (c > 0) {
                        upper = middle - 1;
                        continue;
                    }
                    lower = middle;
                }
                return lower;
            }
        };
        public static final /* enum */ KeyPresentBehavior FIRST_PRESENT = new KeyPresentBehavior(){

            @Override
            <E> int resultIndex(Comparator<? super E> comparator, E key, List<? extends E> list, int foundIndex) {
                int lower = 0;
                int upper = foundIndex;
                while (lower < upper) {
                    int middle = lower + upper >>> 1;
                    int c = comparator.compare(list.get(middle), key);
                    if (c < 0) {
                        lower = middle + 1;
                        continue;
                    }
                    upper = middle;
                }
                return lower;
            }
        };
        public static final /* enum */ KeyPresentBehavior FIRST_AFTER = new KeyPresentBehavior(){

            @Override
            public <E> int resultIndex(Comparator<? super E> comparator, E key, List<? extends E> list, int foundIndex) {
                return LAST_PRESENT.resultIndex(comparator, key, list, foundIndex) + 1;
            }
        };
        public static final /* enum */ KeyPresentBehavior LAST_BEFORE = new KeyPresentBehavior(){

            @Override
            public <E> int resultIndex(Comparator<? super E> comparator, E key, List<? extends E> list, int foundIndex) {
                return FIRST_PRESENT.resultIndex(comparator, key, list, foundIndex) - 1;
            }
        };
        private static final /* synthetic */ KeyPresentBehavior[] $VALUES;

        abstract <E> int resultIndex(Comparator<? super E> var1, E var2, List<? extends E> var3, int var4);

        static {
            $VALUES = new KeyPresentBehavior[]{ANY_PRESENT, LAST_PRESENT, FIRST_PRESENT, FIRST_AFTER, LAST_BEFORE};
        }
    }
}

