/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.preprocessing;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import net.doo.datamining.preprocessing.Stopwords;

public class BagOfWordsFactory$StopwordsConverter
implements IStringConverter<ImmutableSet<String>> {
    @Override
    public ImmutableSet<String> convert(String value) {
        Iterable<String> langs = Splitter.on(',').trimResults().split(value);
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (String lang : langs) {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("stopwords_" + lang + ".txt");
            if (in == null) {
                throw new ParameterException("No stopwords for language code '" + lang + "' found.");
            }
            try {
                result.addAll(Stopwords.readStopwords(in));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new ParameterException("Cannot read stopwords for language '" + value + "'");
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    System.err.println("Error closing resource input stream.");
                    e.printStackTrace(System.err);
                }
            }
        }
        return result.build();
    }
}

