/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.preprocessing;

import com.github.rjeschke.neetutils.CodePointIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;

public class CNormalizer {
    private static final HashMap<Integer, String> MAPPING = new HashMap();

    public static final String normalize(String input) {
        if (input == null || input.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            int ch = input.codePointAt(i);
            CNormalizer.normalizeAndAppend(sb, ch);
            if (ch < 65536) continue;
            ++i;
        }
        return sb.toString();
    }

    private static final void normalizeAndAppend(StringBuilder sb, int codePoint) {
        String lu = MAPPING.get(codePoint);
        if (lu == null) {
            switch (codePoint) {
                case 173: {
                    break;
                }
                default: {
                    sb.appendCodePoint(codePoint);
                    break;
                }
            }
        } else {
            sb.append(lu);
        }
    }

    private static final int toZero(int cp) {
        return cp == -1 ? 0 : cp;
    }

    public static final String normalizeAndPreprocess(String str) {
        CodePointIterator cpi = new CodePointIterator(str, 1, 3);
        StringBuilder output = new StringBuilder(str.length());
        boolean wasHyphen = false;
        while (cpi.getCurrent() != -1) {
            int previous = CNormalizer.toZero(cpi.get(-1));
            int current = CNormalizer.toZero(cpi.getCurrent());
            int next = CNormalizer.toZero(cpi.get(1));
            int sndNext = CNormalizer.toZero(cpi.get(2));
            int thdNext = CNormalizer.toZero(cpi.get(3));
            boolean add = true;
            switch (current) {
                case 173: {
                    add = false;
                    break;
                }
                case 32: {
                    if (!wasHyphen) break;
                    wasHyphen = false;
                    output.append('\n');
                    add = false;
                    break;
                }
                case 45: 
                case 8208: {
                    if (next != 10 || !Character.isLetter(previous) || !Character.isLetter(sndNext)) break;
                    wasHyphen = true;
                    cpi.advance();
                    add = false;
                    break;
                }
                case 10: {
                    if (next != 168 || sndNext != 10 || !Character.isLetter(thdNext)) break;
                    output.appendCodePoint(thdNext);
                    output.append('\u0308');
                    cpi.advance(3);
                    add = false;
                    break;
                }
            }
            if (add) {
                String lu = MAPPING.get(current);
                if (lu == null) {
                    output.appendCodePoint(current);
                } else {
                    output.append(lu);
                }
            }
            cpi.advance();
        }
        return output.toString();
    }

    static {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(CNormalizer.class.getResourceAsStream("/normalize.txt"), "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("\t");
                MAPPING.put(Integer.valueOf(stringArray[0]), stringArray[1]);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not read normalization data from resources.", iOException);
        }
    }
}

