/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.util;

import java.io.Serializable;

public class HashMapInt<K>
implements Serializable {
    Entry<K>[] table;
    int size;
    int threshold;
    final float loadFactor;
    int modCount;
    int defaultValue;

    public HashMapInt(int initialCapacity, float loadFactor, int defaultValue) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.defaultValue = defaultValue;
    }

    public HashMapInt() {
        this(16, 0.75f, 0);
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public int get(K key) {
        if (key == null) {
            return this.getForNullKey();
        }
        int hash = HashMapInt.hash(key.hashCode());
        Entry<K> e = this.table[HashMapInt.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                return e.value;
            }
            e = e.next;
        }
        return this.defaultValue;
    }

    private int getForNullKey() {
        Entry<K> e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                return e.value;
            }
            e = e.next;
        }
        return this.defaultValue;
    }

    public int sum(K key, int value) {
        if (key == null) {
            return this.sumForNullKey(value);
        }
        int hash = HashMapInt.hash(key.hashCode());
        int i = HashMapInt.indexFor(hash, this.table.length);
        Entry<K> e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                e.value += value;
                return e.value;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return value;
    }

    private int sumForNullKey(int value) {
        Entry<K> e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                e.value += value;
                return e.value;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(0, null, value, 0);
        return value;
    }

    void resize(int newCapacity) {
        Entry<K>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry<K>[] newTable) {
        Entry<K>[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry<K> e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = HashMapInt.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    void addEntry(int hash, K key, int value, int bucketIndex) {
        Entry<K> e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<K>(hash, key, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    public static class Entry<K>
    implements Serializable {
        final K key;
        int value;
        Entry<K> next;
        final int hash;

        Entry(int h, K k, int v, Entry<K> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        public final K getKey() {
            return this.key;
        }

        public final int getValue() {
            return this.value;
        }

        public final boolean equals(Object o) {
            int v2;
            int v1;
            K k2;
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && (v1 = this.getValue()) == (v2 = e.getValue());
        }

        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ this.value;
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

