/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter$1;
import com.google.common.base.Splitter$5;
import java.util.Iterator;
import javax.annotation.CheckReturnValue;

public final class Splitter {
    private final CharMatcher trimmer;
    private final boolean omitEmptyStrings;
    private final Strategy strategy;
    private final int limit;

    private Splitter(Strategy strategy) {
        this(strategy, false, CharMatcher.NONE, Integer.MAX_VALUE);
    }

    private Splitter(Strategy strategy, boolean omitEmptyStrings, CharMatcher trimmer, int limit) {
        this.strategy = strategy;
        this.omitEmptyStrings = omitEmptyStrings;
        this.trimmer = trimmer;
        this.limit = limit;
    }

    public static Splitter on(char separator) {
        return Splitter.on(CharMatcher.is(separator));
    }

    public static Splitter on(CharMatcher separatorMatcher) {
        Preconditions.checkNotNull(separatorMatcher);
        return new Splitter((Strategy)((Object)new Splitter$1(separatorMatcher)));
    }

    @CheckReturnValue
    public Splitter trimResults() {
        return this.trimResults(CharMatcher.WHITESPACE);
    }

    @CheckReturnValue
    public Splitter trimResults(CharMatcher trimmer) {
        Preconditions.checkNotNull(trimmer);
        return new Splitter(this.strategy, this.omitEmptyStrings, trimmer, this.limit);
    }

    public Iterable<String> split(CharSequence sequence) {
        Preconditions.checkNotNull(sequence);
        return new Splitter$5(this, sequence);
    }

    private Iterator<String> spliterator(CharSequence sequence) {
        return this.strategy.iterator(this, sequence);
    }

    static /* synthetic */ Iterator access$000(Splitter x0, CharSequence x1) {
        return x0.spliterator(x1);
    }

    static /* synthetic */ CharMatcher access$200(Splitter x0) {
        return x0.trimmer;
    }

    static /* synthetic */ boolean access$300(Splitter x0) {
        return x0.omitEmptyStrings;
    }

    static /* synthetic */ int access$400(Splitter x0) {
        return x0.limit;
    }

    private static interface Strategy {
        public Iterator<String> iterator(Splitter var1, CharSequence var2);
    }
}

