/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.language;

import com.google.common.base.Objects;
import java.io.IOException;
import net.doo.datamining.NGrams;
import net.doo.datamining.io.BinaryChunk;
import net.doo.datamining.language.MarkovConfiguration;
import net.doo.datamining.util.HashMapDouble;

public class MarkovClassifier {
    private String isoCode;
    private long sampleLength;
    private HashMapDouble<String> probabilities;
    public final MarkovConfiguration markovConfiguration;

    public String getIsoCode() {
        return this.isoCode;
    }

    public MarkovClassifier(MarkovConfiguration markovConfiguration) {
        this.markovConfiguration = markovConfiguration;
    }

    public MarkovClassifier fromChunk(BinaryChunk parent) throws IOException {
        BinaryChunk b = parent.readChunk("cfmv");
        this.isoCode = b.readString();
        this.sampleLength = b.readI64();
        int probabilitiesSize = b.readI32();
        this.probabilities = new HashMapDouble(probabilitiesSize * 2, Math.log(1.0 / (double)this.sampleLength));
        for (int n = 0; n < probabilitiesSize; ++n) {
            String ngram = b.readString();
            double probability = b.readDouble();
            this.probabilities.put(ngram, probability);
        }
        return this;
    }

    public double classifyFiltered(String filtered) {
        double score = 0.0;
        for (String ngram : new NGrams<String>(this.markovConfiguration.getK(), filtered)) {
            score += this.probabilities.get(ngram);
        }
        double max = Math.log(0.5) * (double)filtered.length();
        double min = this.probabilities.defaultValue() * (double)filtered.length();
        return (score - min) / (max - min);
    }

    public String toString() {
        return Objects.toStringHelper(this).addValue(this.isoCode).add("sampleLength", this.sampleLength).add("# of probabilities", this.probabilities.size()).toString();
    }
}

