/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.EmptyImmutableMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableMap;
import com.google.common.collect.SingletonImmutableMap;
import com.google.common.collect.TransformedImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ImmutableMap<K, V>
implements Map<K, V>,
Serializable {
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;

    public static <K, V> ImmutableMap<K, V> of() {
        return EmptyImmutableMap.INSTANCE;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        return Maps.immutableEntry(Preconditions.checkNotNull(key, "null key"), Preconditions.checkNotNull(value, "null value"));
    }

    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        ImmutableMap kvMap;
        if (map instanceof ImmutableMap && !(map instanceof ImmutableSortedMap) && !(kvMap = (ImmutableMap)map).isPartialView()) {
            return kvMap;
        }
        Map.Entry[] entries = map.entrySet().toArray(new Map.Entry[0]);
        switch (entries.length) {
            case 0: {
                return ImmutableMap.of();
            }
            case 1: {
                return new SingletonImmutableMap(ImmutableMap.entryOf(entries[0].getKey(), entries[0].getValue()));
            }
        }
        for (int i = 0; i < entries.length; ++i) {
            Object k = entries[i].getKey();
            Object v = entries[i].getValue();
            entries[i] = ImmutableMap.entryOf(k, v);
        }
        return new RegularImmutableMap(entries);
    }

    ImmutableMap() {
    }

    @Override
    public final V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.get(key) != null;
    }

    @Override
    public abstract boolean containsValue(@Nullable Object var1);

    @Override
    public abstract V get(@Nullable Object var1);

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> result = this.entrySet;
        return result == null ? (this.entrySet = this.createEntrySet()) : result;
    }

    abstract ImmutableSet<Map.Entry<K, V>> createEntrySet();

    @Override
    public ImmutableSet<K> keySet() {
        ImmutableSet<K> result = this.keySet;
        return result == null ? (this.keySet = this.createKeySet()) : result;
    }

    ImmutableSet<K> createKeySet() {
        return new KeySet();
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> result = this.values;
        return result == null ? (this.values = this.createValues()) : result;
    }

    ImmutableCollection<V> createValues() {
        return new Values();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            Map that = (Map)object;
            return ((ImmutableSet)this.entrySet()).equals(that.entrySet());
        }
        return false;
    }

    abstract boolean isPartialView();

    @Override
    public int hashCode() {
        return ((ImmutableSet)this.entrySet()).hashCode();
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }

    class Values
    extends ImmutableCollection<V> {
        Values() {
        }

        @Override
        public int size() {
            return ImmutableMap.this.size();
        }

        @Override
        public UnmodifiableIterator<V> iterator() {
            return Maps.valueIterator(((ImmutableSet)ImmutableMap.this.entrySet()).iterator());
        }

        @Override
        public boolean contains(Object object) {
            return ImmutableMap.this.containsValue(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        ImmutableList<V> createAsList() {
            return new TransformedImmutableList<Map.Entry<K, V>, V>(((ImmutableCollection)((Object)ImmutableMap.this.entrySet())).asList()){

                @Override
                V transform(Map.Entry<K, V> entry) {
                    return entry.getValue();
                }
            };
        }
    }

    class KeySet
    extends ImmutableSet.TransformedImmutableSet<Map.Entry<K, V>, K> {
        KeySet() {
            super(ImmutableMap.this.entrySet());
        }

        KeySet(int hashCode) {
            super(ImmutableMap.this.entrySet(), hashCode);
        }

        @Override
        K transform(Map.Entry<K, V> entry) {
            return entry.getKey();
        }

        @Override
        public boolean contains(@Nullable Object object) {
            return ImmutableMap.this.containsKey(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        ImmutableList<K> createAsList() {
            return new TransformedImmutableList<Map.Entry<K, V>, K>(((ImmutableCollection)((Object)ImmutableMap.this.entrySet())).asList()){

                @Override
                K transform(Map.Entry<K, V> entry) {
                    return entry.getKey();
                }
            };
        }
    }

    abstract class EntrySet
    extends ImmutableSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return ImmutableMap.this.size();
        }

        @Override
        public boolean contains(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object value = ImmutableMap.this.get(entry.getKey());
                return value != null && value.equals(entry.getValue());
            }
            return false;
        }

        @Override
        boolean isPartialView() {
            return ImmutableMap.this.isPartialView();
        }
    }

    public static class Builder<K, V> {
        final ArrayList<Map.Entry<K, V>> entries = Lists.newArrayList();

        public Builder<K, V> put(K key, V value) {
            this.entries.add(ImmutableMap.entryOf(key, value));
            return this;
        }

        public ImmutableMap<K, V> build() {
            return Builder.fromEntryList(this.entries);
        }

        private static <K, V> ImmutableMap<K, V> fromEntryList(List<Map.Entry<K, V>> entries) {
            int size = entries.size();
            switch (size) {
                case 0: {
                    return ImmutableMap.of();
                }
                case 1: {
                    return new SingletonImmutableMap<K, V>(Iterables.getOnlyElement(entries));
                }
            }
            Map.Entry[] entryArray = entries.toArray(new Map.Entry[entries.size()]);
            return new RegularImmutableMap(entryArray);
        }
    }
}

