/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.util;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;

public class Iso15924
implements Comparable<Iso15924> {
    public final String alphaCode;
    public final int numericCode;
    public final String englishDescription;
    public final String frenchDescription;
    public final String alias;
    public static final ImmutableMap<String, Iso15924> codeToIso15924;

    private Iso15924(String alphaCode, int numericCode, String englishDescription, String frenchDescription, String alias) {
        this.alphaCode = alphaCode;
        this.numericCode = numericCode;
        this.englishDescription = englishDescription;
        this.frenchDescription = frenchDescription;
        this.alias = alias;
    }

    @Override
    public int compareTo(Iso15924 that) {
        if (that == null) {
            return Integer.MAX_VALUE;
        }
        return this.numericCode - that.numericCode;
    }

    public int hashCode() {
        return this.alphaCode.hashCode();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public String toString() {
        return this.alphaCode + ("".equals(this.alias) ? "" : "/" + this.alias) + " (" + this.englishDescription + ")";
    }

    static {
        HashMap<String, Iso15924> hashMap = new HashMap<String, Iso15924>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Iso15924.class.getClassLoader().getResourceAsStream("iso15924.csv"), Charsets.UTF_8));
        try {
            Splitter splitter = Splitter.on(';');
            for (String string : CharStreams.readLines(bufferedReader)) {
                String string2 = string.trim();
                if ("".equals(string2)) continue;
                Iterator<String> iterator = splitter.split(string2).iterator();
                Iso15924 iso15924 = new Iso15924(iterator.next().trim(), Integer.parseInt(iterator.next().trim()), iterator.next().trim(), iterator.next().trim(), iterator.next().trim());
                hashMap.put(iso15924.alphaCode, iso15924);
                if ("".equals(iso15924.alias)) continue;
                hashMap.put(iso15924.alias, iso15924);
            }
            for (int i = 0; i < 50; ++i) {
                String string;
                string = "Qa" + Character.toString((char)(97 + i / 26)) + Character.toString((char)(97 + i % 26));
                hashMap.put(string, new Iso15924(string, 900 + i, "reserved for private use", "r\u00e9serv\u00e9 \u00e0 l\u2019usage priv\u00e9", ""));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot initialize ISO 15924 data.", exception);
        }
        finally {
            try {
                ((Reader)bufferedReader).close();
            }
            catch (IOException iOException) {
                System.err.println("Warning: error closing resource stream for ISO 15924 data.");
                iOException.printStackTrace();
            }
        }
        codeToIso15924 = ImmutableMap.copyOf(hashMap);
    }
}

