/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.util;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.TreeMap;
import net.doo.datamining.util.Iso15924;
import net.doo.datamining.util.Pair;

public final class UnicodeScript {
    private static final int[] startIdxs;
    private static final int[] endIdxs;
    private static final Iso15924[] scripts;
    public static final Iso15924 unknown;
    public static final Iso15924 common;
    public static final Iso15924 inherit;
    public static final Iso15924 hans;
    public static final Iso15924 hant;
    public static final Iso15924 hani;
    public static final Iso15924 hira;
    public static final Iso15924 kana;
    public static final Iso15924 hang;
    public static final Iso15924 latn;
    public static final Iso15924 cyrl;
    public static final Iso15924 arab;
    public static final Iso15924 deva;
    public static final ImmutableMultimap<Iso15924, String> scriptToLang;
    public static final ImmutableMap<String, Iso15924> langToScript;
    private static final Iso15924 cjk;
    public static final ImmutableSortedSet<Iso15924> unicodeScripts;

    private UnicodeScript() {
    }

    private static Iso15924 getIso(String id, int lineCounter) {
        Iso15924 script = Iso15924.codeToIso15924.get(id);
        if (script == null) {
            throw new RuntimeException("Could not read unicode script data: " + id + " in line " + (lineCounter - 1));
        }
        return script;
    }

    private static int[] parseRange(String range) {
        String trimmed = range.trim();
        int dotIndex = trimmed.indexOf("..");
        int rangeStart = dotIndex == -1 ? Integer.parseInt(trimmed, 16) : Integer.parseInt(trimmed.substring(0, dotIndex), 16);
        int rangeEnd = dotIndex == -1 ? rangeStart : Integer.parseInt(trimmed.substring(dotIndex + 2), 16);
        return new int[]{rangeStart, rangeEnd};
    }

    public static int getNGramLength(Iso15924 script) {
        if (script == latn) {
            return 6;
        }
        if (script == cyrl) {
            return 5;
        }
        if (script == arab) {
            return 4;
        }
        if (script == deva) {
            return 4;
        }
        if (script == cjk) {
            return 3;
        }
        return 2;
    }

    static {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Object object6;
        unknown = Iso15924.codeToIso15924.get("Zzzz");
        common = Iso15924.codeToIso15924.get("Zyyy");
        inherit = Iso15924.codeToIso15924.get("Zinh");
        hans = Iso15924.codeToIso15924.get("Hans");
        hant = Iso15924.codeToIso15924.get("Hant");
        hani = Iso15924.codeToIso15924.get("Hani");
        hira = Iso15924.codeToIso15924.get("Hira");
        kana = Iso15924.codeToIso15924.get("Kana");
        hang = Iso15924.codeToIso15924.get("Hang");
        latn = Iso15924.codeToIso15924.get("Latn");
        cyrl = Iso15924.codeToIso15924.get("Cyrl");
        arab = Iso15924.codeToIso15924.get("Arab");
        deva = Iso15924.codeToIso15924.get("Deva");
        cjk = Iso15924.codeToIso15924.get("Qaaa");
        TreeMap<Pair<Integer, Integer>, Iso15924> treeMap = new TreeMap<Pair<Integer, Integer>, Iso15924>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(UnicodeScript.class.getClassLoader().getResourceAsStream("Scripts.txt"), Charsets.UTF_8));
        try {
            object6 = Splitter.on(';');
            String string2 = "";
            int n = -1;
            int n2 = -1;
            int n3 = 0;
            for (String object7 : CharStreams.readLines(bufferedReader)) {
                ++n3;
                int string3 = object7.indexOf(35);
                string = string3 == -1 ? object7 : object7.substring(0, string3);
                object4 = string.trim();
                if ("".equals(object4)) continue;
                object3 = ((Splitter)object6).split((CharSequence)object4).iterator();
                object2 = UnicodeScript.parseRange(object3.next());
                object = object3.next().trim();
                if (object2[0] < 0 || object2[1] < 0 || object2[1] < object2[0]) {
                    throw new RuntimeException(String.format("Invalid range [%x,%x] in line %d", object2[0], object2[1], n3));
                }
                if (n2 + 1 != object2[0] || !string2.equals(object)) {
                    if (n2 != -1) {
                        treeMap.put(Pair.of(n, n2), UnicodeScript.getIso(string2, n3));
                    }
                    n = object2[0];
                }
                n2 = object2[1];
                string2 = object;
            }
            treeMap.put(Pair.of(n, n2), UnicodeScript.getIso(string2, n3));
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot initialize Unicode Script data.", exception);
        }
        finally {
            try {
                ((Reader)bufferedReader).close();
            }
            catch (IOException iOException) {
                System.err.println("Warning: error closing resource stream for Unicode data.");
                iOException.printStackTrace();
            }
        }
        startIdxs = new int[treeMap.size()];
        endIdxs = new int[treeMap.size()];
        scripts = new Iso15924[treeMap.size()];
        object6 = ImmutableSortedSet.naturalOrder();
        int n = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            UnicodeScript.startIdxs[n] = (Integer)((Pair)entry.getKey()).fst;
            UnicodeScript.endIdxs[n] = (Integer)((Pair)entry.getKey()).snd;
            UnicodeScript.scripts[n] = (Iso15924)entry.getValue();
            ((ImmutableSortedSet.Builder)object6).add(entry.getValue());
            ++n;
        }
        unicodeScripts = ((ImmutableSortedSet.Builder)object6).build();
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(UnicodeScript.class.getClassLoader().getResourceAsStream("langToScript.csv"), Charsets.UTF_8));
        try {
            Splitter splitter = Splitter.on(';');
            ImmutableMultimap.Builder<Object, Object> builder = ImmutableMultimap.builder();
            ImmutableMap.Builder builder2 = ImmutableMap.builder();
            for (String string4 : CharStreams.readLines(bufferedReader2)) {
                string = string4.trim();
                if ("".equals(string)) continue;
                object4 = splitter.split(string).iterator();
                object3 = ((String)object4.next()).trim();
                object2 = ((String)object4.next()).trim();
                object = Iso15924.codeToIso15924.get(object2);
                builder.put(object, object3);
                builder2.put(object3, object);
            }
            scriptToLang = builder.build();
            langToScript = builder2.build();
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot initialize lang<->script data.", exception);
        }
        finally {
            try {
                ((Reader)bufferedReader2).close();
            }
            catch (IOException iOException) {
                System.err.println("Warning: error closing resource stream for script->lang data.");
                iOException.printStackTrace();
            }
        }
    }
}

