/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.WriterAppender;

public class ConsoleAppender
extends WriterAppender {
    protected String target = "System.out";
    private boolean follow = false;

    public void activateOptions() {
        if (this.follow) {
            if (this.target.equals("System.err")) {
                this.setWriter(this.createWriter(new SystemErrStream()));
            } else {
                this.setWriter(this.createWriter(new SystemOutStream()));
            }
        } else if (this.target.equals("System.err")) {
            this.setWriter(this.createWriter(System.err));
        } else {
            this.setWriter(this.createWriter(System.out));
        }
        super.activateOptions();
    }

    protected final void closeWriter() {
        if (this.follow) {
            super.closeWriter();
        }
    }

    private static class SystemOutStream
    extends OutputStream {
        public void close() {
        }

        public void flush() {
            System.out.flush();
        }

        public void write(byte[] b) throws IOException {
            System.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            System.out.write(b, off, len);
        }

        public void write(int b) throws IOException {
            System.out.write(b);
        }
    }

    private static class SystemErrStream
    extends OutputStream {
        public void close() {
        }

        public void flush() {
            System.err.flush();
        }

        public void write(byte[] b) throws IOException {
            System.err.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            System.err.write(b, off, len);
        }

        public void write(int b) throws IOException {
            System.err.write(b);
        }
    }
}

