/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Collections2 {
    public static <T> Comparator<T> reverse(final Comparator<T> c) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return -c.compare(o1, o2);
            }
        };
    }

    public static <T> ImmutableList<T> sort(Collection<T> ts, Comparator c) {
        ArrayList<T> result = new ArrayList<T>(ts);
        Collections.sort(result, c);
        return ImmutableList.copyOf(result);
    }

    public static <T> List<T> tail(List<T> ts) {
        ArrayList<T> result = new ArrayList<T>(ts.size() - 1);
        Iterator<T> iter = ts.iterator();
        iter.next();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public static <T> ImmutableList<T> take(ImmutableList<T> ts, int count) {
        int toTake = Math.min(ts.size(), count);
        return ts.subList(0, toTake);
    }

    public static <N extends Number> double min(Collection<N> numbers) {
        double result = Double.POSITIVE_INFINITY;
        for (Number n : numbers) {
            result = Math.min(result, n.doubleValue());
        }
        return result;
    }

    public static <N extends Number> double sum(Collection<N> numbers) {
        double result = 0.0;
        for (Number n : numbers) {
            result += n.doubleValue();
        }
        return result;
    }
}

