/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.doo.datamining.util.Pair;

public class ConfusionMatrix {
    private final Collection<Entry> classificationResults = Lists.newArrayList();
    private final TreeMap<String, Double> minConfidences = Maps.newTreeMap();
    private int instances = 0;
    private int positiveInstances = 0;
    private int negativeInstances = 0;

    public ConfusionMatrix() {
        this.minConfidences.put("0", 0.0);
    }

    public double getMinConfidence(String category) {
        Double minConfidence = this.minConfidences.get(category);
        if (minConfidence == null) {
            return 0.0;
        }
        return minConfidence;
    }

    public void addResult(String actualClass, String detectedClass, String filename, double confidence) {
        this.classificationResults.add(new Entry(actualClass, detectedClass, filename, confidence));
        ++this.instances;
        if ("0".equals(actualClass)) {
            ++this.negativeInstances;
        } else {
            ++this.positiveInstances;
        }
        if (!this.minConfidences.containsKey(actualClass)) {
            this.minConfidences.put(actualClass, 0.0);
        }
        if (!this.minConfidences.containsKey(detectedClass)) {
            this.minConfidences.put(detectedClass, 0.0);
        }
    }

    public Collection<String> getCategories() {
        return Collections.unmodifiableSet(this.minConfidences.keySet());
    }

    public Collection<String> getPositiveCategories() {
        TreeSet<String> result = new TreeSet<String>(this.getCategories());
        result.remove("0");
        return result;
    }

    ArrayListMultimap<Pair<String, String>, Entry> calculateMatrix() {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (Entry entry : this.classificationResults) {
            String resultingClass = entry.confidence >= this.getMinConfidence(entry.detectedClass) ? entry.detectedClass : "0";
            result.put(Pair.of(entry.actualClass, resultingClass), (Object)entry);
        }
        return result;
    }

    private int rowSum(ArrayListMultimap<Pair<String, String>, Entry> matrixData, String originalCategory) {
        int sum = 0;
        for (String detectedCategory : this.getCategories()) {
            sum += matrixData.get(Pair.of(originalCategory, detectedCategory)).size();
        }
        return sum;
    }

    public int columnSum(ArrayListMultimap<Pair<String, String>, Entry> matrixData, String detectedCategory) {
        int sum = 0;
        for (String originalCategory : this.getCategories()) {
            sum += matrixData.get(Pair.of(originalCategory, detectedCategory)).size();
        }
        return sum;
    }

    private double calculatePrecision(ArrayListMultimap<Pair<String, String>, Entry> matrixData, String category) {
        double correct = matrixData.get(Pair.of(category, category)).size();
        double total = this.columnSum(matrixData, category);
        if (total == 0.0) {
            return 0.0;
        }
        return correct / total;
    }

    private double calculateRecall(ArrayListMultimap<Pair<String, String>, Entry> matrixData, String category) {
        double correct = matrixData.get(Pair.of(category, category)).size();
        double total = this.rowSum(matrixData, category);
        if (total == 0.0) {
            return 0.0;
        }
        return correct / total;
    }

    public static double calculateFMeasure(double beta, double precision, double recall) {
        double betaSq = beta * beta;
        if (precision + recall == 0.0) {
            return 0.0;
        }
        return (1.0 + betaSq) * (precision * recall) / (betaSq * precision + recall);
    }

    public ConfusionMatrixResult calculateResult(double beta) {
        return new ConfusionMatrixResult(this, beta);
    }

    public static String int2str26(int num) {
        StringBuilder sb = new StringBuilder();
        int i = num;
        do {
            sb.append((char)(97 + i % 26));
        } while ((i = i / 26 - 1) >= 0);
        return sb.reverse().toString();
    }

    public static class ConfusionMatrixResult {
        public final Collection<String> categories;
        public final ArrayListMultimap<Pair<String, String>, Entry> matrixData;
        public final int instances;
        public final int positiveInstances;
        public final int negativeInstances;
        public final int truePositives;
        public final int falsePositives;
        public final int falseNegatives;
        public final double truePositivesPercent;
        public final double falseNegativesPercent;
        public final double falsePositivesPercent;
        public final Map<String, Double> precision;
        public final Map<String, Double> recall;
        public final Map<String, Double> fMeasure;
        public final double avgPrecision;
        public final double avgFMeasure;
        public final double beta;

        ConfusionMatrixResult(ConfusionMatrix m, double beta) {
            this.categories = ImmutableList.copyOf(m.getCategories());
            this.matrixData = m.calculateMatrix();
            this.instances = m.instances;
            this.positiveInstances = m.positiveInstances;
            this.negativeInstances = m.negativeInstances;
            int truePositivesCount = 0;
            int falseNegativesCount = 0;
            for (String string : m.getPositiveCategories()) {
                truePositivesCount += this.matrixData.get(Pair.of(string, string)).size();
                falseNegativesCount += this.matrixData.get(Pair.of(string, "0")).size();
            }
            this.truePositives = truePositivesCount;
            this.falseNegatives = falseNegativesCount;
            int falsePositivesCount = 0;
            for (String correctCategory : this.categories) {
                for (String detectedCategory : m.getPositiveCategories()) {
                    if (correctCategory.equals(detectedCategory)) continue;
                    falsePositivesCount += this.matrixData.get(Pair.of(correctCategory, detectedCategory)).size();
                }
            }
            this.falsePositives = falsePositivesCount;
            if (this.positiveInstances == 0) {
                this.truePositivesPercent = 0.0;
                this.falseNegativesPercent = 0.0;
            } else {
                this.truePositivesPercent = (double)this.truePositives * 100.0 / (double)this.positiveInstances;
                this.falseNegativesPercent = (double)this.falseNegatives * 100.0 / (double)this.positiveInstances;
            }
            this.falsePositivesPercent = this.instances == 0 ? 0.0 : (double)this.falsePositives * 100.0 / (double)this.instances;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableMap.Builder recallBuilder = ImmutableMap.builder();
            ImmutableMap.Builder fMeasureBuilder = ImmutableMap.builder();
            double precisionSum = 0.0;
            double fMeasureSum = 0.0;
            for (String c : this.categories) {
                double p = m.calculatePrecision((ArrayListMultimap<Pair<String, String>, Entry>)this.matrixData, c);
                double r = m.calculateRecall((ArrayListMultimap<Pair<String, String>, Entry>)this.matrixData, c);
                double f = ConfusionMatrix.calculateFMeasure(beta, p, r);
                precisionSum += p;
                fMeasureSum += f;
                builder.put((Object)c, (Object)p);
                recallBuilder.put((Object)c, (Object)r);
                fMeasureBuilder.put((Object)c, (Object)f);
            }
            this.precision = builder.build();
            this.avgPrecision = precisionSum / (double)(this.precision.size() > 0 ? this.precision.size() : 1);
            this.recall = recallBuilder.build();
            this.fMeasure = fMeasureBuilder.build();
            this.avgFMeasure = fMeasureSum / (double)(this.fMeasure.size() > 0 ? this.fMeasure.size() : 1);
            this.beta = beta;
        }

        public String printMatrix() {
            return this.printMatrix(false);
        }

        public String printMatrix(boolean useFullLabels) {
            String headerLabel = "category\u2193 classified as\u2192";
            StringBuilder b = new StringBuilder();
            DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
            df.setMinimumFractionDigits(3);
            df.setMaximumFractionDigits(3);
            DecimalFormat percent = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
            percent.setMinimumFractionDigits(2);
            percent.setMaximumFractionDigits(2);
            int columnWidth = 5;
            for (Iterator<String> pair : this.matrixData.keys()) {
                columnWidth = Math.max(columnWidth, Integer.toString(this.matrixData.get((Object)pair).size()).length());
            }
            ++columnWidth;
            int categoryWidth = 0;
            for (String s : this.categories) {
                categoryWidth = Math.max(categoryWidth, s.length());
            }
            categoryWidth = Math.max(categoryWidth, "category\u2193 classified as\u2192".length());
            if (useFullLabels) {
                b.append(Strings.padStart((String)"category\u2193 classified as\u2192", (int)categoryWidth, (char)' '));
                for (String c : this.categories) {
                    b.append(Strings.padStart((String)c, (int)columnWidth, (char)' ')).append(' ');
                }
            } else {
                b.append(Strings.padStart((String)"category\u2193 classified as\u2192", (int)(categoryWidth + 3), (char)' '));
                for (int c = 0; c < this.categories.size(); ++c) {
                    b.append(Strings.padStart((String)(ConfusionMatrix.int2str26(c) + ""), (int)columnWidth, (char)' ')).append(' ');
                }
            }
            b.append(" | recall\n");
            int c = 0;
            for (String correctCategory : this.categories) {
                if (useFullLabels) {
                    b.append(Strings.padEnd((String)correctCategory, (int)categoryWidth, (char)' '));
                } else {
                    b.append(Strings.padEnd((String)(ConfusionMatrix.int2str26(c) + ": " + correctCategory), (int)(categoryWidth + 3), (char)' '));
                }
                for (String detectedCategory : this.categories) {
                    int size = this.matrixData.get(Pair.of(correctCategory, detectedCategory)).size();
                    String sizeString = size == 0 ? " " : size + "";
                    b.append(Strings.padStart((String)sizeString, (int)columnWidth, (char)' ')).append(' ');
                }
                b.append(" | ").append(df.format(this.recall.get(correctCategory))).append('\n');
                ++c;
            }
            b.append('\n');
            b.append(Strings.padStart((String)"precision:", (int)categoryWidth, (char)' ')).append("   ");
            for (String detectedCategory : this.categories) {
                b.append(Strings.padStart((String)df.format(this.precision.get(detectedCategory)), (int)columnWidth, (char)' ')).append(' ');
            }
            b.append(" \u2300 " + df.format(this.avgPrecision));
            b.append("\n");
            b.append(Strings.padStart((String)("f-Measure (\u03b2=" + df.format(this.beta) + "):"), (int)categoryWidth, (char)' ')).append("   ");
            for (String detectedCategory : this.categories) {
                b.append(Strings.padStart((String)df.format(this.fMeasure.get(detectedCategory)), (int)columnWidth, (char)' ')).append(' ');
            }
            b.append(" \u2300 " + df.format(this.avgFMeasure));
            b.append("\n\n");
            b.append("Total Sum       ").append(Strings.padStart((String)(this.instances + ""), (int)7, (char)' ')).append('\n').append("True Positives  ").append(Strings.padStart((String)(this.truePositives + ""), (int)7, (char)' ')).append("  ").append(Strings.padStart((String)percent.format(this.truePositivesPercent), (int)6, (char)' ')).append("%\n").append("False Negatives ").append(Strings.padStart((String)(this.falseNegatives + ""), (int)7, (char)' ')).append("  ").append(Strings.padStart((String)percent.format(this.falseNegativesPercent), (int)6, (char)' ')).append("%\n").append("False Positives ").append(Strings.padStart((String)(this.falsePositives + ""), (int)7, (char)' ')).append("  ").append(Strings.padStart((String)percent.format(this.falsePositivesPercent), (int)6, (char)' ')).append("%\n");
            return b.toString();
        }
    }

    public static class Entry {
        final String actualClass;
        final String detectedClass;
        final String filename;
        final double confidence;

        public Entry(String actualClass, String detectedClass, String filename, double confidence) {
            this.actualClass = actualClass;
            this.detectedClass = detectedClass;
            this.filename = filename;
            this.confidence = confidence;
        }
    }
}

