/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class NGrams<T extends CharSequence>
implements Iterable<T> {
    private final Collection<T> strings;
    private final int n;

    public NGrams(int n, T string) {
        this(n, (Collection<T>)Collections.singleton(string));
    }

    public NGrams(int n, Collection<T> strings) {
        if (n < 1) {
            throw new IllegalArgumentException("n < 1: " + n);
        }
        this.n = n;
        this.strings = strings;
    }

    @Override
    public Iterator<T> iterator() {
        return new NGramIterator();
    }

    private class NGramIterator
    implements Iterator<T> {
        private Iterator<T> iter;
        private T current;
        private int pos = 0;
        private boolean hasNext = false;

        private NGramIterator() {
            this.iter = NGrams.this.strings.iterator();
            this.advanceToNextString();
        }

        private void advanceToNextString() {
            this.hasNext = false;
            this.pos = 0;
            while (this.iter.hasNext()) {
                this.current = (CharSequence)this.iter.next();
                if (!this.currentHasNext()) continue;
                this.hasNext = true;
                break;
            }
        }

        private boolean currentHasNext() {
            return this.current.length() - this.pos >= NGrams.this.n;
        }
    }
}

