/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.io;

import java.io.IOException;
import net.doo.datamining.io.BinaryChunk;

public class InfoChunkData {
    private int majorVersion = 0;
    private int minorVersion = 0;
    private int revision = 0;
    private String algoName = "        ";

    public InfoChunkData fromChunk(BinaryChunk bc) throws IOException {
        BinaryChunk infoChunk = bc.readChunk("info");
        this.majorVersion = infoChunk.readI32();
        this.minorVersion = infoChunk.readI32();
        this.revision = infoChunk.readI32();
        this.algoName = infoChunk.readASCIIString(8);
        return this;
    }

    public InfoChunkData assertValidity(int expectedMajorVersion, int minMinorVersion, String expectedAlgoName) throws IOException {
        if (this.majorVersion != expectedMajorVersion) {
            throw new IOException("Wrong major version: " + this.majorVersion + ", expected: " + expectedMajorVersion);
        }
        if (!expectedAlgoName.equals(this.algoName)) {
            throw new IOException("Wrong algorithm name: '" + this.algoName + "', expected '" + expectedAlgoName + "'");
        }
        if (minMinorVersion < minMinorVersion) {
            throw new IOException("Minor Version too small: " + this.minorVersion + ", expected: " + minMinorVersion + " or higher.");
        }
        return this;
    }
}

