/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.util;

import java.io.Serializable;

public class HashSetInt
implements Iterable<Integer>,
Serializable {
    Entry[] table;
    int size;
    int threshold;
    final float loadFactor;
    int modCount;

    public HashSetInt(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
    }

    public HashSetInt(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashSetInt() {
        this(16, 0.75f);
    }

    public HashSetInt(String s) {
        this(s.length() * 2);
        for (int n = 0; n < s.length(); ++n) {
            this.add(s.charAt(n));
        }
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public boolean contains(int value) {
        int hash = HashSetInt.hash(value);
        Entry e = this.table[HashSetInt.indexFor(hash, this.table.length)];
        while (e != null) {
            if (e.value == value) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public boolean add(int value) {
        int hash = HashSetInt.hash(value);
        int i = HashSetInt.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.value == value) {
                return true;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, value, i);
        return false;
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = HashSetInt.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    void addEntry(int hash, int value, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry(hash, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    static class Entry {
        int value;
        Entry next;
        final int hash;

        Entry(int h, int v, Entry n) {
            this.value = v;
            this.next = n;
            this.hash = h;
        }
    }
}

