/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.util;

import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class LogUtils {
    public static void initConsoleLogging(String logLevel) {
        Level level = Level.toLevel((String)logLevel);
        ConsoleAppender console = new ConsoleAppender();
        console.setWriter((Writer)new OutputStreamWriter(System.out));
        console.setThreshold((Priority)level);
        console.setLayout(new Layout(){

            public void activateOptions() {
            }

            public boolean ignoresThrowable() {
                return false;
            }

            public String format(LoggingEvent event) {
                StringBuilder b = new StringBuilder(512);
                b.append(event.getRenderedMessage()).append('\n');
                String[] throwableStrRep = event.getThrowableStrRep();
                if (throwableStrRep != null) {
                    for (String s : throwableStrRep) {
                        b.append(s).append('\n');
                    }
                }
                return b.toString();
            }
        });
        Logger.getRootLogger().removeAllAppenders();
        Logger.getRootLogger().addAppender((Appender)console);
        Logger.getRootLogger().setLevel(level);
    }
}

