/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.kmeans;

import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.TreeSet;
import net.doo.datamining.AggregatedClassificationResults;
import net.doo.datamining.ClassificationResults;
import net.doo.datamining.ConfusionMatrix;
import net.doo.datamining.io.ArffAttribute;
import net.doo.datamining.io.ArffWriter;
import net.doo.datamining.util.Pair;
import org.apache.log4j.Logger;

public class ResultWriter {
    private static final Logger log = Logger.getLogger(ResultWriter.class);
    public final ImmutableList<AggregatedClassificationResults> results;
    public final ConfusionMatrix matrix;
    public final double beta;
    public final String configuration;

    public ResultWriter(ImmutableList<AggregatedClassificationResults> results, String configuration, double beta) {
        this.results = results;
        this.matrix = new ConfusionMatrix();
        for (AggregatedClassificationResults result : results) {
            this.matrix.addResult((String)result.wv.categoryKey.fst, (String)result.bestResult.categoryKey.fst, result.wv.originalFilename, result.confidence);
        }
        this.configuration = configuration;
        this.beta = beta;
    }

    public void writeStratifiedResult(File dir, String algoName) throws IOException {
        dir.mkdirs();
        this.writeArff(new File(dir, "result.arff"), algoName);
        this.writeCSV(new File(dir, "scores.csv"));
        this.writeHtml(new File(dir, "result.html"));
        ConfusionMatrix.ConfusionMatrixResult matrixResult = this.matrix.calculateResult(this.beta);
        log.info('\n' + matrixResult.printMatrix() + '\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeArff(File file, String title) throws IOException {
        file.getParentFile().mkdirs();
        ArffWriter writer = new ArffWriter(title, new ArffAttribute.NominalArffAttribute("best", this.matrix.getCategories()), new ArffAttribute.NominalArffAttribute("2ndBest", this.matrix.getCategories()), new ArffAttribute.NumericArffAttribute("confidence"), new ArffAttribute.NumericArffAttribute("bestScore"), new ArffAttribute.NumericArffAttribute("2ndBestScore"), new ArffAttribute.NumericArffAttribute("inputLength"), new ArffAttribute.StringArffAttribute("filename"), new ArffAttribute.NominalArffAttribute("@@class@@", this.matrix.getCategories()), new ArffAttribute.NominalArffAttribute("@@learnClass@@", this.matrix.getCategories()));
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8));){
            writer.writeHeader(out);
            for (AggregatedClassificationResults result : this.results) {
                writer.writeEntry(out, ResultWriter.map("best", ((ClassificationResults.ClassificationResult)result.rawScores.get((int)0)).categoryKey.fst, "2ndBest", ((ClassificationResults.ClassificationResult)result.rawScores.get((int)1)).categoryKey.fst, "confidence", result.confidence, "bestScore", ((ClassificationResults.ClassificationResult)result.processedScores.get((int)0)).score, "2ndBestScore", ((ClassificationResults.ClassificationResult)result.processedScores.get((int)1)).score, "inputLength", result.wv.originalContentLength, "filename", result.wv.originalFilename, "@@class@@", result.wv.categoryKey.fst, "@@learnClass@@", ((String)result.wv.categoryKey.fst).equals(result.bestResult.categoryKey.fst) ? (String)result.wv.categoryKey.fst : "0"));
            }
        }
    }

    private static Map<String, Object> map(Object ... os) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int n = 0; n < os.length; n += 2) {
            builder.put((Object)((String)os[n]), os[n + 1]);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCSV(File file) throws IOException {
        file.getParentFile().mkdirs();
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
            boolean headerWritten = false;
            for (AggregatedClassificationResults result : this.results) {
                String bestCategory = (String)result.bestResult.categoryKey.fst;
                if (!headerWritten) {
                    w.write("filename;inputLength;class;detectedClass;learnClass;confidence");
                    for (ClassificationResults.ClassificationResult cr : ClassificationResults.byNameAsc(result.processedScores)) {
                        w.write(";class-");
                        w.write((String)cr.categoryKey.fst);
                    }
                    ((Writer)w).write(10);
                    headerWritten = true;
                }
                w.write(result.wv.originalFilename);
                w.write(";");
                w.write(Double.toString(result.wv.originalContentLength));
                w.write(";");
                w.write((String)result.wv.categoryKey.fst);
                w.write(";");
                w.write(bestCategory);
                w.write(";");
                w.write(((String)result.wv.categoryKey.fst).equals(bestCategory) ? (String)result.wv.categoryKey.fst : "0");
                w.write(";");
                w.write(Double.toString(result.confidence));
                for (ClassificationResults.ClassificationResult cr : ClassificationResults.byNameAsc(result.processedScores)) {
                    w.write(";");
                    w.write(Double.toString(cr.score));
                }
                ((Writer)w).write(10);
            }
            ((Writer)w).flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHtml(File file) throws IOException {
        file.getParentFile().mkdirs();
        ArrayListMultimap falseDetections = ArrayListMultimap.create();
        for (AggregatedClassificationResults result : this.results) {
            String detectedClass = (String)result.bestResult.categoryKey.fst;
            String correctClass = (String)result.wv.categoryKey.fst;
            if (detectedClass.equals(correctClass)) continue;
            falseDetections.put(Pair.of(correctClass, detectedClass), (Object)result);
        }
        int catcount = this.matrix.getCategories().size();
        ConfusionMatrix.ConfusionMatrixResult matrixResult = this.matrix.calculateResult(0.25);
        try (BufferedWriter html = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));){
            html.write("<!doctype html>\n");
            html.write("<html>\n");
            html.write("<head>\n");
            html.write("<title>Results</title>\n");
            html.write("<meta charset=\"UTF-8\" />\n");
            html.write("<style type=\"text/css\">\n");
            html.write(".tab {border: 1px solid #000; padding: 0px; margin: 0px; border-spacing: 0px;}\n");
            html.write(".gray {width: 15%; border: 1px solid #000; background-color:#b0b0b0;}\n");
            html.write(".grays {width: " + 80 / (catcount + 1) + "%; text-align: center; border: 1px solid #000; background-color:#b0b0b0;}\n");
            html.write(".green {text-align: center; border: 1px solid #000; background-color:#00e000;}\n");
            html.write(".red {text-align: center; border: 1px solid #000; background-color:#e06060;}\n");
            html.write(".orange {text-align: center; border: 1px solid #000; background-color:orange;}\n");
            html.write(".yellow {text-align: center; border: 1px solid #000; background-color:yellow;}\n");
            html.write(".normal {text-align: center; border: 1px solid #000;}\n");
            html.write(".console {text-align: left; font-family: monospace;}\n");
            html.write("a {color: black;}\n");
            html.write("</style>\n");
            html.write("</head>\n");
            html.write("<body>\n");
            html.write("<p>\n");
            html.write("<table class=\"tab\">\n");
            html.write("<tr>\n");
            html.write("<td class=\"gray\">category &darr; classified as &rarr;</td>");
            for (int i = 0; i < catcount; ++i) {
                html.write("<td class=\"grays\">" + ConfusionMatrix.int2str26(i) + "</td>");
            }
            html.write("<td class=\"grays\">recall</td>");
            html.write("</tr>\n");
            int y = 0;
            for (String actualClass : matrixResult.categories) {
                html.write("<tr><td class=\"gray\">");
                html.write(ConfusionMatrix.int2str26(y));
                html.write(": ");
                html.write(actualClass);
                html.write("</td>");
                int x = 0;
                for (String detectedClass : matrixResult.categories) {
                    int s = matrixResult.matrixData.get(Pair.of(actualClass, detectedClass)).size();
                    String target = "#" + actualClass + "_" + detectedClass;
                    html.write("<td class=\"");
                    if (x == y) {
                        html.write("green");
                    } else if (s == 0) {
                        html.write("normal");
                    } else if (x == 0) {
                        html.write("orange");
                    } else {
                        html.write("red");
                    }
                    html.write("\">");
                    if (s == 0 && x != y) {
                        html.write("&nbsp;");
                    } else if (x == y) {
                        html.write(Integer.toString(s));
                    } else {
                        html.write(String.format("<a href=\"%s\">%d</a>", target, s));
                    }
                    html.write("</td>");
                    ++x;
                }
                html.write("<td class=\"yellow\">" + String.format("% 4.3f", matrixResult.recall.get(actualClass)) + "</td>");
                html.write("</tr>\n");
                ++y;
            }
            html.write("<tr>\n");
            html.write("<td class=\"gray\">precision</td>");
            for (String clazz : matrixResult.categories) {
                html.write(String.format("<td class=\"yellow\">% 4.3f</td>", matrixResult.precision.get(clazz)));
            }
            html.write(String.format("<td class=\"grays\">\u2300 % 4.3f</td>", matrixResult.avgPrecision));
            html.write("</tr>\n");
            html.write("<tr>\n");
            html.write(String.format("<td class=\"gray\">f-Measure (\u03b2=% 4.3f)</td>", matrixResult.beta));
            for (String clazz : matrixResult.categories) {
                html.write(String.format("<td class=\"yellow\">% 4.3f</td>", matrixResult.fMeasure.get(clazz)));
            }
            html.write(String.format("<td class=\"grays\">\u2300 % 4.3f</td>", matrixResult.avgFMeasure));
            html.write("</tr>\n");
            html.write("</table>");
            html.write("</p>\n");
            html.write("<pre class=\"console\">\n");
            html.write(String.format("Total Sum       % 6d\n", matrixResult.instances));
            html.write(String.format("True Positives  % 6d  % 4.2f\n", matrixResult.truePositives, matrixResult.truePositivesPercent));
            html.write(String.format("False Negatives % 6d  % 4.2f\n", matrixResult.falseNegatives, matrixResult.falseNegativesPercent));
            html.write(String.format("False Positives % 6d  % 4.2f\n", matrixResult.falsePositives, matrixResult.falsePositivesPercent));
            html.write("</pre>\n");
            html.write("<p>\n");
            html.write("Learned with configuration: <br>\n");
            html.write(this.configuration);
            html.write("</p>\n");
            html.write("<p>\n");
            for (Pair actualAndDetected : new TreeSet(falseDetections.keySet())) {
                String actual = (String)actualAndDetected.fst;
                String detected = (String)actualAndDetected.snd;
                String target = actual + "_" + detected;
                html.write("<h2 id=\"" + target + "\">\"" + actual + "\" falsely classified as \"" + detected + "\"</h2>\n");
                for (AggregatedClassificationResults result : falseDetections.get((Object)actualAndDetected)) {
                    html.write("<a href=\"" + result.wv.originalFilename + "\">" + result.wv.originalFilename + "</a>, score: " + result.bestResult.score + "<br/>");
                }
            }
            html.write("</p>\n");
            html.write("</body>\n");
            html.write("</html>\n");
        }
    }
}

