/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.language;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import net.doo.datamining.io.BinaryChunk;
import net.doo.datamining.language.MarkovClassifier;
import net.doo.datamining.language.MarkovConfiguration;

public class LanguageLearningResult {
    private MarkovConfiguration markovConfiguration = new MarkovConfiguration();
    private ImmutableList<MarkovClassifier> classifiers = ImmutableList.of();

    public MarkovConfiguration getMarkovConfiguration() {
        return this.markovConfiguration;
    }

    public ImmutableList<MarkovClassifier> getClassifiers() {
        return this.classifiers;
    }

    public LanguageLearningResult fromChunk(BinaryChunk bc) throws IOException {
        this.markovConfiguration.fromChunk(bc);
        BinaryChunk cs = bc.readChunk("csmv");
        int classifiersCount = cs.readI32();
        ImmutableList.Builder classifiersBuilder = ImmutableList.builder();
        for (int n = 0; n < classifiersCount; ++n) {
            classifiersBuilder.add((Object)new MarkovClassifier(this.markovConfiguration).fromChunk(cs));
        }
        this.classifiers = classifiersBuilder.build();
        return this;
    }
}

