package net.doo.snap.lib.ui.widget.text;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.TextView;

import net.doo.snap.lib.R;
import net.doo.snap.lib.ui.widget.text.processor.BulletProcessStrategy;
import net.doo.snap.lib.ui.widget.text.processor.StressedProcessStrategy;
import net.doo.snap.lib.ui.widget.text.processor.TextProcessor;

/**
 * Lets you specify custom Typeface in XML
 */
@SuppressWarnings("unused")
public class CustomTypefaceTextView extends TextView {

    private TypefaceProvider typefaceProvider;
    private TextProcessor textProcessor = new TextProcessor();

    public CustomTypefaceTextView(Context context) {
        super(context);
    }

    public CustomTypefaceTextView(Context context, AttributeSet attrs) {
        super(context, attrs);

        initView(context, attrs);
    }

    public CustomTypefaceTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);

        initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        typefaceProvider = new TypefaceProvider();

        boolean updateText = false;

        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CustomTypefaceTextView);

        try {
            String typefaceName = a.getString(R.styleable.CustomTypefaceTextView_fontName);
            initMainTypeface(context, typefaceName);

            String stressTypefaceName = a.getString(R.styleable.CustomTypefaceTextView_stressFontName);
            updateText |= initStressTypeface(context, stressTypefaceName);

            Drawable bullet = a.getDrawable(R.styleable.CustomTypefaceTextView_bullet);
            updateText |= initBullet(bullet);
        } finally {
            a.recycle();
        }

        if (updateText) {
            setText(getText()); //update text with new TextProcessor parameters
        }
    }

    private void initMainTypeface(Context context, String typefaceName) {
        if (typefaceName == null || isInEditMode()) {
            return;
        }

        setTypeface(typefaceProvider.getTypeface(context, typefaceName));
    }

    private boolean initStressTypeface(Context context, String typefaceName) {
        if (typefaceName == null || isInEditMode()) {
            return false;
        }

        textProcessor.addStrategy(
                new StressedProcessStrategy(typefaceProvider.getTypeface(context, typefaceName))
        );
        return true;
    }

    private boolean initBullet(Drawable bullet) {
        if (bullet == null || isInEditMode()) {
            return false;
        }

        textProcessor.addStrategy(
                new BulletProcessStrategy(bullet)
        );
        return true;
    }

    @Override
    public void setText(CharSequence text, BufferType type) {
        if (textProcessor != null) {
            type = BufferType.SPANNABLE;
            text = textProcessor.processText(text.toString());
        }

        super.setText(text, type);
    }
}
