package net.doo.snap.lib.analytics;

import com.google.analytics.tracking.android.ExceptionParser;

import org.apache.commons.lang.exception.ExceptionUtils;

/**
 * Provides extended description about {@link java.lang.Throwable} for usage in analytics
 */
public class AnalyticsExceptionParser implements ExceptionParser {

    @Override
    public String getDescription(String thread, Throwable throwable) {
        return "Thread: " + thread + ", Exception: " + ExceptionUtils.getStackTrace(throwable);
    }

}
