/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Build;
import android.view.TextureView;
import android.view.View;
import com.commonsware.cwac.camera.CameraView;
import com.commonsware.cwac.camera.PreviewStrategy;
import java.io.IOException;

@TargetApi(value=14)
class TexturePreviewStrategy
implements PreviewStrategy,
TextureView.SurfaceTextureListener {
    private final CameraView cameraView;
    private TextureView widget = null;
    private SurfaceTexture surface = null;

    TexturePreviewStrategy(CameraView cameraView) {
        this.cameraView = cameraView;
        this.widget = new TextureView(cameraView.getContext());
        this.widget.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.surface = surface;
        this.cameraView.previewCreated();
        this.cameraView.initPreview(width, height);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        this.cameraView.previewReset(width, height);
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.cameraView.previewDestroyed();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public void attach(Camera camera) throws IOException {
        camera.setPreviewTexture(this.surface);
    }

    public void attach(MediaRecorder recorder) {
        if (Build.VERSION.SDK_INT < 16) {
            throw new IllegalStateException("Cannot use TextureView with MediaRecorder");
        }
    }

    public View getWidget() {
        return this.widget;
    }
}

