package net.doo.snap.lib;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;

import net.doo.snap.lib.snap.camera.HostProvider;
import net.doo.snap.lib.snap.camera.SnapCameraHost;
import net.doo.snap.lib.snap.camera.debug.DebugCameraHost;
import net.doo.snap.lib.snap.edit.EditLock;
import net.doo.snap.lib.util.bitmap.BitmapLruCache;

import roboguice.inject.ContextSingleton;

@SuppressWarnings("unused")
public class SnapModule extends AbstractModule {

    @Override
    protected void configure() {
        bind(BitmapLruCache.class).in(Singleton.class);
        bind(EditLock.class).in(ContextSingleton.class);

        bind(SnapCameraHost.class).toProvider(HostProvider.class);
    }

}
